/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.wizards;

import java.net.URI;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;

import com.curl.eclipse.remote.DialogViewProxy;
import com.curl.eclipse.remote.ProjectCreationWizardViewProxy;
import com.curl.eclipse.util.CoreUtil;
import com.curl.eclipse.util.CurlUIIDs;

public class NewProjectWizardPage extends CurlWizardPage
{
    private ProjectCreationWizardViewProxy fProxy;
    private IProject fProjectHandle;
    private IProjectDescription fProjectDescription;
    private final String fProjectComment = WizardMessages.NewProjectWizardPage_0;
    private final String[] fCurlNature = { CurlUIIDs.ID_CURL_NATURE };

    public NewProjectWizardPage(
            String title,
            String description)
    {
        super(
                title,
                description,
                WizardMessages.WizardNewProjectPage_name,
                CurlUIIDs.ID_NEW_CURL_PROJECT_CONTEXT_ID);
    }

    public boolean performFinish(
            IProgressMonitor monitor) throws CoreException, InterruptedException
    {
        boolean succeeded = false;
        StringBuffer projNameReturnedByMediator = new StringBuffer();
        StringBuffer dirURLReturnedByMediator = new StringBuffer();
        StringBuffer projIsInWorkspaceReturnedByMediator = new StringBuffer(); // yes, or no
        try {
            monitor.beginTask(WizardMessages.WizardElementCreation_op_inprogress, 3);
            if (fProxy.performValidation(
                    projNameReturnedByMediator,
                    dirURLReturnedByMediator,
                    projIsInWorkspaceReturnedByMediator)) {
                // Dialog is validated. Create the Eclipse project first and
                // then tell the proxy to create the Curl project.
                fProjectHandle = ResourcesPlugin.getWorkspace().getRoot().getProject(
                        projNameReturnedByMediator.toString());
                fProjectDescription = fProjectHandle.getWorkspace().newProjectDescription(
                        projNameReturnedByMediator.toString());
                if (projIsInWorkspaceReturnedByMediator.toString().equals(WizardMessages.NewProjectWizardPage_1)) {
                    fProjectDescription.setLocation(null);
                } else {
                    fProjectDescription.setLocationURI(new URI(dirURLReturnedByMediator.toString()));
                }
                fProjectDescription.setName(projNameReturnedByMediator.toString());
                fProjectDescription.setComment(fProjectComment);
                fProjectDescription.setNatureIds(fCurlNature);
                if (!fProjectHandle.exists()) {
                    fProjectHandle.create(fProjectDescription, monitor);
                    if (fProxy.createProject()) {
                        fProjectHandle.open(monitor);
                        fProjectHandle.refreshLocal(IResource.DEPTH_INFINITE, monitor);
                        succeeded = true;
                    } else {
                        CoreUtil.logError("Creating project fail after validation!"); //$NON-NLS-1$
                        fProjectHandle.delete(true, true, monitor);
                    }
                    fProxyIsClosed = true;
                    fProxy.destroy();
                } else {
                    CoreUtil.logError("Project already exists eventhough validation passed!"); //$NON-NLS-1$
                }
            }
        } catch (OperationCanceledException e) {
            // FIXME:  We need to handle the cancel case.  
        } catch (Exception e) {
            CoreUtil.logError("Error creating project: " + projNameReturnedByMediator.toString(), e); //$NON-NLS-1$
            if (fProjectHandle != null)
                fProjectHandle.delete(true, true, monitor);
        } finally {
            if (monitor != null)
                monitor.done();
        }
        return succeeded;
    }

    @Override
    protected void establishViewProxy()
    {
        if (fProxy == null) {
            fProxy = new ProjectCreationWizardViewProxy(this, Platform.getInstanceLocation().getURL().toString());
            fProxy.createViewForDialog(fPageComposite);
        }
    }

    @Override
    protected DialogViewProxy getProxy() 
    {
        return fProxy;
    }

    IProject getResourceHandle()
    {
        return fProjectHandle;
    }
}
