/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.wizards;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

import com.curl.eclipse.CurlPlugin;

public class NewProjectWizard extends NewElementWizard implements IExecutableExtension
{
    private IConfigurationElement fConfigElement;
    private NewProjectWizardPage fNewProjectPage;

    public NewProjectWizard() {
        setDialogSettings(CurlPlugin.getDefault().getDialogSettings());
        setWindowTitle(WizardMessages.CurlProjectWizard_title);
    }

    @Override
    public void addPages()
    {
        super.addPages();
        fNewProjectPage = new NewProjectWizardPage(WizardMessages.WizardNewProjectPage_title,
                WizardMessages.WizardNewProjectPage_description);
        addPage(fNewProjectPage);
    }

    @Override
    protected boolean finishPage(
            IProgressMonitor monitor) throws InterruptedException, CoreException
    {
        return fNewProjectPage.performFinish(monitor);
    }

    @Override
    public boolean performFinish()
    {
        boolean res = super.performFinish();
        if (res) {
            BasicNewProjectResourceWizard.updatePerspective(fConfigElement);
            selectAndReveal(fNewProjectPage.getResourceHandle());
        }
        return res;
    }

    /*
     * Stores the configuration element for the wizard. The config element will
     * be used in <code>performFinish</code> to set the result perspective.
     */
    public void setInitializationData(
            IConfigurationElement cfig,
            String propertyName,
            Object data)
    {
        fConfigElement = cfig;
    }

    @Override
    public boolean performCancel()
    {
        fNewProjectPage.performCancel();
        return super.performCancel();
    }
}
