/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.wizards;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

import com.curl.eclipse.CurlPlugin;

public class NewPackageWizard extends NewElementWizard
{
    private NewFileWizardPage fNewFilePage;

    public NewPackageWizard() {
        super();
        setDialogSettings(CurlPlugin.getDefault().getDialogSettings());
        setWindowTitle(WizardMessages.NewPackageWizard_title);
    }

    @Override
    public void addPages()
    {
        super.addPages();
        if (fNewFilePage == null) {
            fNewFilePage = new NewFileWizardPage(WizardMessages.WizardNewPackagePage_title,
                    WizardMessages.WizardNewPackagePage_description, true);
            fNewFilePage.init(getSelection());
        }
        addPage(fNewFilePage);
    }

    @Override
    protected boolean finishPage(
            IProgressMonitor monitor) throws InterruptedException, CoreException
    {
        return fNewFilePage.performFinish(monitor); // use the full progress
        // monitor
    }

    @Override
    public boolean performFinish()
    {
        boolean res = super.performFinish();
        IResource file = fNewFilePage.getResourceHandle();
        if (res == true && file != null) {
            selectAndReveal(file);
        }
        return res;
    }

    @Override
    public boolean performCancel()
    {
        fNewFilePage.performCancel();
        return super.performCancel();
    }
}
