/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;

import com.curl.eclipse.remote.DialogViewProxy;
import com.curl.eclipse.remote.NewFileWizardViewProxy;
import com.curl.eclipse.util.CoreUtil;
import com.curl.eclipse.util.CurlUIIDs;

public class NewFileWizardPage extends CurlWizardPage
{
    private NewFileWizardViewProxy fProxy;
    private String fSelectedDir;
    private IFile fNewFileFile;
    private final boolean fCreatePackageMode;

    public NewFileWizardPage(
            String title,
            String description,
            boolean createPackage)
    {
        super(
                title,
                description,
                WizardMessages.WizardNewFilePage_name,
                CurlUIIDs.ID_NEW_CURL_PACKAGE_AND_FILE_CONTEXT_ID);
        fCreatePackageMode = createPackage;
    }

    public void init(
            IStructuredSelection selection)
    {
        fSelectedDir = CoreUtil.getSelectedResourceDirectory(selection);
    }

    public boolean performFinish(
            IProgressMonitor monitor) throws CoreException, InterruptedException
    {
        boolean succeeded = false;
        try {
            monitor.beginTask(WizardMessages.WizardElementCreation_op_inprogress, 3);
            StringBuffer fileURIReturnedByMediator = new StringBuffer();
            // Validate the dialog and have the proxy create the file if
            // validation succeeds. Destroy the proxy in anticipation of the
            // entire dialog going away.
            if (fProxy.validateAndCreateFile(fileURIReturnedByMediator)) {
                succeeded = true;
                fNewFileFile = CoreUtil.openEditorOnUrl(fileURIReturnedByMediator.toString());
                fProxyIsClosed = true;
                fProxy.destroy();
            } else { 
                // Likely causes:  Either user decided not to overwrite an existing file or
                // writing the file itself failed.
            }
        } finally {
            if (monitor != null)
                monitor.done();
        }
        return succeeded;
    }

    @Override
    protected DialogViewProxy getProxy() {
        return fProxy;
    }

    @Override
    protected void establishViewProxy()
    {
        if (fProxy == null) {
            fProxy = new NewFileWizardViewProxy(this, fSelectedDir, fCreatePackageMode);
            fProxy.createViewForDialog(fPageComposite);
        }
    }

    IResource getResourceHandle()
    {
        return fNewFileFile;
    }
}
