/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.wizards;

import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

import com.curl.eclipse.util.ExceptionHandler;

public abstract class NewElementWizard extends Wizard implements INewWizard
{
    private IWorkbench fWorkbench;
    private IStructuredSelection fSelection;

    public NewElementWizard() {
        setNeedsProgressMonitor(true);
    }

    /*
     * protected void openResource(final IFile resource) { final IWorkbenchPage
     * activePage= JavaPlugin.getActivePage(); if (activePage != null) { final
     * Display display= getShell().getDisplay(); if (display != null) {
     * display.asyncExec(new Runnable() { public void run() { try {
     * IDE.openEditor(activePage, resource, true); } catch (PartInitException e) {
     * JavaPlugin.log(e); } } }); } } }
     */
    /**
     * Subclasses should override to perform the actions of the wizard. This
     * method is run in the wizard container's context as a workspace runnable.
     * 
     * I changed this method from returning void to returning boolean because
     * our wizard page checks validation after pressing Finish.
     * 
     * @param monitor
     * @throws InterruptedException
     * @throws CoreException
     */
    protected abstract boolean finishPage(
            IProgressMonitor monitor) throws InterruptedException, CoreException;

    protected void handleFinishException(
            Shell shell,
            InvocationTargetException e)
    {
        ExceptionHandler.handle(e, shell, WizardMessages.WizardElementCreation_op_error_title,
                WizardMessages.WizardElementCreation_op_error_message);
    }

    /*
     * @see Wizard#performFinish
     */
    @Override
    public boolean performFinish()
    {
        /*
         * Job finishJob = new Job("Creating Element...") { protected IStatus
         * run(IProgressMonitor monitor) { try { finishPage(monitor); } catch
         * (InterruptedException e) { throw new
         * OperationCanceledException(e.getMessage()); } catch (CoreException e) {
         * throw new OperationCanceledException(e.getMessage()); } return
         * Status.OK_STATUS; } };
         * 
         * finishJob.schedule();
         */
        try {
            return finishPage(new NullProgressMonitor());
        } catch (InterruptedException e) {
            throw new OperationCanceledException(e.getMessage());
        } catch (CoreException e) {
            throw new OperationCanceledException(e.getMessage());
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.ui.IWorkbenchWizard#init(org.eclipse.ui.IWorkbench,
     *      org.eclipse.jface.viewers.IStructuredSelection)
     */
    public void init(
            IWorkbench workbench,
            IStructuredSelection currentSelection)
    {
        fWorkbench = workbench;
        fSelection = currentSelection;
    }

    public IStructuredSelection getSelection()
    {
        return fSelection;
    }

    public IWorkbench getWorkbench()
    {
        return fWorkbench;
    }

    protected void selectAndReveal(
            IResource newResource)
    {
        BasicNewResourceWizard.selectAndReveal(newResource, fWorkbench.getActiveWorkbenchWindow());
    }
}
