/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.wizards;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;

import com.curl.eclipse.remote.DialogViewProxy;

public abstract class CurlWizardPage extends WizardPage
{
    protected boolean fProxyIsClosed;
    protected Composite fPageComposite;
    private final String fPageHelpID;

    public CurlWizardPage(
            String title, 
            String description, 
            String newPageName,
            String helpID) {
        super(newPageName);
        setPageComplete(false);
        setTitle(title);
        setDescription(description);
        fPageHelpID = helpID;
    }

    public void createControl(
            Composite parent)
    {
        fPageComposite = new Composite(parent, SWT.NULL);
        setProperSizeForViewProxy();
        setControl(fPageComposite);
        // TODO: Communicate with mediator as to when turn on/off finish button
        establishViewProxy();
        PlatformUI.getWorkbench().getHelpSystem().setHelp(fPageComposite, fPageHelpID);
        fPageComposite.addControlListener(new ControlAdapter() {
            @Override
            public void controlResized(
                    ControlEvent e)
            {
                establishViewProxy();
                setNewSize();
            }

            @Override
            public void controlMoved(
                    ControlEvent e)
            {
                establishViewProxy();
                setNewSize();
            }
        });
        // Although we say the page is complete, validation of the page is
        // currently implement after you press finish. Hence, Finish can
        // result in a validation error. Ideally, and according to Eclipse
        // usability "rules", the Finish button is enabled only when all fields
        // are validated dynamically. We should do this someday!
        setPageComplete(true);
    }

    protected abstract void establishViewProxy();
    protected abstract DialogViewProxy getProxy();

    void performCancel()
    {
        // TODO: Should send a cancel to the mediator
        fProxyIsClosed = true;
        getProxy().destroy();
    }
    
    private void setNewSize()
    {
        if (!fProxyIsClosed)
            getProxy().resizePage(fPageComposite);
    }

    private void setProperSizeForViewProxy()
    {
        fPageComposite.setLayout(new RowLayout());
        Button button = new Button(fPageComposite, SWT.PUSH);
        button.setLayoutData(new RowData(460, 390));
    }
}
