/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.util;

import java.lang.reflect.Method;

import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.Composite;

/*
 * Manage a hWin
 */
public class WindowHandle
{
    private int fHWin;

    /*
     * Create a handle for the hWin
     */
    @SuppressWarnings("unchecked") 
    public WindowHandle(Composite composite) {
        if (Platform.getOS().equals(Platform.OS_WIN32)) {
            fHWin = composite.handle;
            return;
        }
        Boolean isX11WindowingSystem = false;
        Class<Object> gtkOSClass = null;
        try {
            gtkOSClass = (Class<Object>)Class.forName("org.eclipse.swt.internal.gtk.OS"); //$NON-NLS-1$
            Method GDK_WINDOWING_X11_Method = gtkOSClass.getMethod("GDK_WINDOWING_X11", new Class[0]); //$NON-NLS-1$
            isX11WindowingSystem = (Boolean)GDK_WINDOWING_X11_Method.invoke(null, new Object[0]);
        } catch (Exception e) {
            CoreUtil.logError("Could not determine windowing system.", e); //$NON-NLS-1$
            throw new RuntimeException(e);
        }
        if (isX11WindowingSystem) {
            try {
                // we accomplish the below using reflection:
                // 
                // int window = OS.GTK_WIDGET_WINDOW (hWin);
                // int xWindow = OS.gdk_x11_drawable_get_xid (window);
                // fHWin = xWindow;
                //    
                Method GTK_WIDGET_WINDOW_Method = gtkOSClass.getMethod("GTK_WIDGET_WINDOW", new Class[] { int.class }); //$NON-NLS-1$
                Method gdk_x11_drawable_get_xid_Method = gtkOSClass.getMethod("gdk_x11_drawable_get_xid", //$NON-NLS-1$
                        new Class[] { int.class });
                Integer window = (Integer)GTK_WIDGET_WINDOW_Method.invoke(null, new Object[] { new Integer(
                        composite.handle) });
                Integer xWindow = (Integer)gdk_x11_drawable_get_xid_Method.invoke(null, new Object[] { window });
                fHWin = xWindow.intValue();
            } catch (Exception e) {
                CoreUtil.logError("Error determining windowing system.", e); //$NON-NLS-1$
            }
        } else {
            CoreUtil.logError("Windowing system could not be determined."); //$NON-NLS-1$
        }
    }

    /*
     * Get the raw handle
     */
    public int getHandle()
    {
        return fHWin;
    }
}
