/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.util;

import java.nio.charset.Charset;

/**
 * Just a test utility tp dump all charset supported by Java.
 * 
 * @author fmisiak
 *
 */
public class JavaCharset
{
    public static void main(
            String[] args)
    {
        int count = 0;
        for(Charset cs : Charset.availableCharsets().values()) {
            System.out.println(++count + ":" + cs.name()); //$NON-NLS-1$
            for(String alias: cs.aliases()) {
                System.out.print("\t"); //$NON-NLS-1$
                System.out.println(alias);
            }
            System.out.println();
        }
    }
}
