/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.util;

import org.eclipse.ui.texteditor.ITextEditorActionDefinitionIds;

/**
 * Defines the definition IDs for the Curl editor actions.
 *  see org.eclipse.jdt.ui.actions.IJavaEditorActionDefinitionIds
 */
public interface ICurlEditorActionDefinitionIds extends ITextEditorActionDefinitionIds
{
    /**
     * Action definition ID of the edit -> Fix Indentation action (value
     * <code>"com.curl.eclipse.editor.fixindentation"</code>).
     *
     * @since 3.0
     */
    public static final String FIX_INDENTATION = "com.curl.eclipse.editor.fixindentation"; //$NON-NLS-1$

    /**
     * Action definition ID of the navigate -> open action
     * (value <code>"com.curl.eclipse.edit.text.open.editor"</code>).
     */
    public static final String OPEN_EDITOR= "com.curl.eclipse.edit.text.open.editor"; //$NON-NLS-1$

    /**
     * Action IDs used to find an action registered in the editor or used to set
     * a definition Id.
     */
    public static final String FixIndentationActionId = "FixIndentation";   //$NON-NLS-1$

    public static final String COMMENT = "com.curl.eclipse.editor.comment"; //$NON-NLS-1$
    public static final String CommentActionId = "Comment"; //$NON-NLS-1$

    public static final String UNCOMMENT = "com.curl.eclipse.editor.uncomment"; //$NON-NLS-1$
    public static final String UncommentActionId = "Uncomment"; //$NON-NLS-1$

    public static final String BALANCE = "com.curl.eclipse.editor.balance"; //$NON-NLS-1$
    public static final String BalanceActionId = "Balance"; //$NON-NLS-1$

    public static final String SHOW_COMPLETIONS = "com.curl.eclipse.editor.showcompletions"; //$NON-NLS-1$
    public static final String ShowCompletionsActionId = "ShowCompletions"; //$NON-NLS-1$

    public static final String TOGGLE_BREAKPOINT = "com.curl.eclipse.editor.togglebreakpoint"; //$NON-NLS-1$
    public static final String ToggleBreakpointActionId = "ToggleBreakpoint"; //$NON-NLS-1$

    public static final String ContinueToHereActionId = "ContinueToHere"; //$NON-NLS-1$

    public static final String COPY_TO_WATCH = "com.curl.eclipse.editor.copytowatch"; //$NON-NLS-1$
    public static final String CopyToWatchActionId = "CopyToWatch"; //$NON-NLS-1$
    
    public static final String LANGUAGE_DOCUMENTATION = "com.curl.eclipse.editor.language-documentation"; //$NON-NLS-1$
    public static final String LanguageDocumentationActionId = "LanguageDocumentation"; //$NON-NLS-1$

    public static final String SHOW_IN_CLASS_BROWSER = "com.curl.eclipse.editor.show-in-class-browser"; //$NON-NLS-1$
    public static final String ShowInClassBrowserActionId = "ShowInClassBrowser"; //$NON-NLS-1$

    public static final String SEARCH_DEFINITIONS_IN_WS = "com.curl.eclipse.editor.search.declarations.in.workspace"; //$NON-NLS-1$
    public static final String SearchDefinitionInWSActionId = "SearchDefinitionInWS"; //$NON-NLS-1$

    public static final String GOTO_DEFINITIONS_IN_WS = "com.curl.eclipse.editor.goto.declarations.in.workspace"; //$NON-NLS-1$
    public static final String GotoDefinitionInWSActionId = "GotoDefinitionInWS"; //$NON-NLS-1$

    public static final String SEARCH_REFERENCES_IN_WS = "com.curl.eclipse.editor.search.references.in.workspace"; //$NON-NLS-1$
    public static final String SearchReferenceInWSActionId = "SearchReferenceInWS"; //$NON-NLS-1$

    public static final String PAGE_LEFT = "com.curl.eclipse.editor.pageleft"; //$NON-NLS-1$
    public static final String PageLeftActionId = "PageLeft"; //$NON-NLS-1$
    
    public static final String PAGE_RIGHT = "com.curl.eclipse.editor.pageright"; //$NON-NLS-1$
    public static final String PageRightActionId = "PageRight"; //$NON-NLS-1$

    public static final String SELECT_PAGE_LEFT = "com.curl.eclipse.editor.selectpageleft"; //$NON-NLS-1$
    public static final String SelectPageLeftActionId = "SelectPageLeft"; //$NON-NLS-1$
    
    public static final String SELECT_PAGE_RIGHT = "com.curl.eclipse.editor.selectpageright"; //$NON-NLS-1$
    public static final String SelectPageRightActionId = "SelectPageRight"; //$NON-NLS-1$
    
    public static final String SCROLL_PAGE_LEFT = "com.curl.eclipse.editor.scrollpageleft"; //$NON-NLS-1$
    public static final String ScrollPageLeftActionId = "ScrollPageLeft"; //$NON-NLS-1$
    
    public static final String SCROLL_PAGE_RIGHT = "com.curl.eclipse.editor.scrollpageright"; //$NON-NLS-1$
    public static final String ScrollPageRightActionId = "ScrollPageRight"; //$NON-NLS-1$
    
    public static final String SCROLL_COLUMN_LEFT = "com.curl.eclipse.editor.scrollcolumnleft"; //$NON-NLS-1$
    public static final String ScrollColumnLeftActionId = "ScrollColumnLeft"; //$NON-NLS-1$
    
    public static final String SCROLL_COLUMN_RIGHT = "com.curl.eclipse.editor.scrollcolumnright"; //$NON-NLS-1$
    public static final String ScrollColumnRightActionId = "ScrollColumnRight"; //$NON-NLS-1$
    
    public static final String INDENTED_NEW_LINE = "com.curl.eclipse.editor.indentednewline"; //$NON-NLS-1$
    public static final String IndentedNewLineActionId = "IndentedNewLine"; //$NON-NLS-1$
    
    public static final String UNIT_UP = "com.curl.eclipse.editor.unitup"; //$NON-NLS-1$
    public static final String UnitUpActionId = "unitup"; //$NON-NLS-1$
    
    public static final String UNIT_DOWN = "com.curl.eclipse.editor.unitdown"; //$NON-NLS-1$
    public static final String UnitDownActionId = "unitdown"; //$NON-NLS-1$

    public static final String SELECT_UNIT_UP = "com.curl.eclipse.editor.selectunitup"; //$NON-NLS-1$
    public static final String SelectUnitUpActionId = "selectunitup"; //$NON-NLS-1$
    
    public static final String SELECT_UNIT_DOWN = "com.curl.eclipse.editor.selectunitdown"; //$NON-NLS-1$
    public static final String SelectUnitDownActionId = "selectunitdown"; //$NON-NLS-1$

    public static final String SELECT_UNIT_LEFT = "com.curl.eclipse.editor.selectunitleft"; //$NON-NLS-1$
    public static final String SelectUnitLeftActionId = "selectunitleft"; //$NON-NLS-1$
    
    public static final String SELECT_UNIT_RIGHT = "com.curl.eclipse.editor.selectunitright"; //$NON-NLS-1$
    public static final String SelectUnitRightActionId = "selectunitright"; //$NON-NLS-1$

    public static final String EXPRESSION_UP = "com.curl.eclipse.editor.expressionup"; //$NON-NLS-1$
    public static final String ExpressionUpActionId = "expressionup"; //$NON-NLS-1$

    public static final String EXPRESSION_DOWN = "com.curl.eclipse.editor.expressiondown"; //$NON-NLS-1$
    public static final String ExpressionDownActionId = "expressiondown"; //$NON-NLS-1$
    
    public static final String EXPRESSION_LEFT = "com.curl.eclipse.editor.expressionleft"; //$NON-NLS-1$
    public static final String ExpressionLeftActionId = "expressionleft"; //$NON-NLS-1$

    public static final String EXPRESSION_RIGHT = "com.curl.eclipse.editor.expressionright"; //$NON-NLS-1$
    public static final String ExpressionRightActionId = "expressionright"; //$NON-NLS-1$

    public static final String SELECT_EXPRESSION_UP = "com.curl.eclipse.editor.selectexpressionup"; //$NON-NLS-1$
    public static final String SelectExpressionUpActionId = "selectexpressionup"; //$NON-NLS-1$

    public static final String SELECT_EXPRESSION_DOWN = "com.curl.eclipse.editor.selectexpressiondown"; //$NON-NLS-1$
    public static final String SelectExpressionDownActionId = "selectexpressiondown"; //$NON-NLS-1$
    
    public static final String SELECT_EXPRESSION_LEFT = "com.curl.eclipse.editor.selectexpressionleft"; //$NON-NLS-1$
    public static final String SelectExpressionLeftActionId = "selectexpressionleft"; //$NON-NLS-1$

    public static final String SELECT_EXPRESSION_RIGHT = "com.curl.eclipse.editor.selectexpressionright"; //$NON-NLS-1$
    public static final String SelectExpressionRightActionId = "selectexpressionright"; //$NON-NLS-1$

    public static final String SELECT_BLOCK = "com.curl.eclipse.editor.selectblock"; //$NON-NLS-1$
    public static final String SelectBlockActionId = "selectblock"; //$NON-NLS-1$

    public static final String INSERT_START_BRACE = "com.curl.eclipse.editor.insertstartbrace"; //$NON-NLS-1$
    public static final String InsertStartBraceActionId = "insertstartbrace"; //$NON-NLS-1$

    public static final String INSERT_END_BRACE = "com.curl.eclipse.editor.insertendbrace"; //$NON-NLS-1$
    public static final String InsertEndBraceActionId = "insertendbrace"; //$NON-NLS-1$
    
    public static final String CENTER_CURSOR = "com.curl.eclipse.editor.centercursor"; //$NON-NLS-1$
    public static final String CenterCursorActionId = "centercursor"; //$NON-NLS-1$

    public static final String SWITCH_POINT_AND_ANCHOR = "com.curl.eclipse.editor.switchpointandanchor"; //$NON-NLS-1$
    public static final String SwitchPointAndAnchorActionId = "switchpointandanchor"; //$NON-NLS-1$

    public static final String INSERT_TAB = "com.curl.eclipse.editor.inserttab"; //$NON-NLS-1$
    public static final String InsertTabActionId = "inserttab"; //$NON-NLS-1$
    
    public static final String CANCEL_SELECTION = "com.curl.eclipse.editor.cancelselection"; //$NON-NLS-1$
    public static final String CancelSelectionActionId = "cancelselection"; //$NON-NLS-1$
}
