/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.util;



public interface CurlUIIDs
{
    /**
     * IDs defined in plugin.xml and used in other places
     */
    public static final String ID_PLUGIN = "com.curl.eclipse.plugin"; //$NON-NLS-1$
    public static final String ID_PERSPECTIVE = "com.curl.eclipse.perspectives.DevelopmentPerspective"; //$NON-NLS-1$
    public static final String ID_CURL_NATURE = "com.curl.eclipse.plugin.CurlNature"; //$NON-NLS-1$
    public static final String ID_CURL_EDITOR = "com.curl.eclipse.CurlEditor"; //$NON-NLS-1$
    public static final String ID_CURL_VLE_EDITOR = "com.curl.eclipse.editors.VLEEditor"; //$NON-NLS-1$
    public static final String ID_CURL_DEFINITIONS = "com.curl.eclipse.editors.CurlDefinitionsView"; //$NON-NLS-1$
    public static final String ID_CURL_MANIFEST_EXPLORER = "com.curl.eclipse.editors.CurlManifestExplorerView"; //$NON-NLS-1$
    public static final String ID_ELEMENT_CREATION_ACTION_SET = "com.curl.eclipse.ElementCreationActionSet"; //$NON-NLS-1$
    public static final String ID_PROJECT_ACTION_SET = "com.curl.eclipse.ProjectActionSet"; //$NON-NLS-1$
    public static final String ID_EDIT_COMPONENT_TARGET_SETTINGS_ACTION = "com.curl.eclipse.project.EditComponentTargetSettingsAction"; //$NON-NLS-1$
    public static final String ID_PROJECT_CHANGE_API_VERSION = "com.curl.eclipse.project.changeapiversion";   //$NON-NLS-1$
    public static final String ID_CURL_TOOLS_ACTION_SET = "com.curl.eclipse.CurlToolsActionSet";   //$NON-NLS-1$
    public static final String ID_CURL_DEBUG_ACTION_SET = "com.curl.eclipse.CurlDebugActionSet"; //$NON-NLS-1$
    public static final String ID_CURL_LINE_DEBUG_MARKER = "com.curl.eclipse.plugin.curlLineBreakpointMarker"; //$NON-NLS-1$
    public static final String ID_CURL_PROBLEM_MARKER = "com.curl.eclipse.plugin.curlProblemMarker"; //$NON-NLS-1$
    public static final String ID_CURL_EXCEPTION_DEBUG_MARKER = "com.curl.eclipse.plugin.curlExceptionBreakpointMarker"; //$NON-NLS-1$
    public static final String ID_CURL_TARGET_PROJECT_PROPERTIES_ID = "com.curl.eclipse.properties.CurlTargetsProjectPropertiesPage"; //$NON-NLS-1$

    /**
     * Context sensitive help IDs
     */
    public static final String ID_MANIFEST_EXPLORER_CONTEXT_ID = CurlUIIDs.ID_PLUGIN + ".ManifestExplorerContextID";   //$NON-NLS-1$
    public static final String ID_DEFINITIONS_CONTEXT_ID = CurlUIIDs.ID_PLUGIN + ".DefinitionsContextID";   //$NON-NLS-1$
    public static final String ID_EDITOR_CONTEXT_ID = CurlUIIDs.ID_PLUGIN + ".EditorContextID";   //$NON-NLS-1$
    public static final String ID_OUTLINE_CONTEXT_ID = CurlUIIDs.ID_PLUGIN + ".OutlineContextID";   //$NON-NLS-1$
    public static final String ID_GENERAL_PROJECT_PROPERTIES_CONTEXT_ID = CurlUIIDs.ID_PLUGIN + ".GeneralProjectPropertiesContextID";   //$NON-NLS-1$
    public static final String ID_TARGETS_PROJECT_PROPERTIES_CONTEXT_ID = CurlUIIDs.ID_PLUGIN + ".TargetsProjectPropertiesContextID";   //$NON-NLS-1$
    public static final String ID_STYLE_SHEET_PROJECT_PROPERTIES_CONTEXT_ID = CurlUIIDs.ID_PLUGIN + ".StyleSheetProjectPropertiesContextID";   //$NON-NLS-1$
    public static final String ID_GENERAL_PREFERENCES_CONTEXT_ID = CurlUIIDs.ID_PLUGIN + ".GeneralPreferencesContextID";   //$NON-NLS-1$
    public static final String ID_EDITOR_PREFERENCES_CONTEXT_ID = CurlUIIDs.ID_PLUGIN + ".EditorPreferencesContextID";   //$NON-NLS-1$
    public static final String ID_LICENSE_PREFERENCES_CONTEXT_ID = CurlUIIDs.ID_PLUGIN + ".LicensePreferencesContextID";   //$NON-NLS-1$
    public static final String ID_NEW_CURL_PROJECT_CONTEXT_ID = CurlUIIDs.ID_PLUGIN + ".NewCurlProjectContextID";   //$NON-NLS-1$
    public static final String ID_NEW_CURL_PACKAGE_AND_FILE_CONTEXT_ID = CurlUIIDs.ID_PLUGIN + ".NewCurlPackageAndFileContextID";   //$NON-NLS-1$
    
    public static final String LAUNCH_CONFIGURATION_DIALOG_LAUNCH_APPLET_MAIN_TAB = CurlUIIDs.ID_PLUGIN + ".LaunchAppletMainTabContextID";   //$NON-NLS-1$
    public static final String ADD_EXCEPTION_BREAKPOINT_ACTION_DIALOG = CurlUIIDs.ID_PLUGIN + ".AddExceptionBreakpointContextID";   //$NON-NLS-1$
    public static final String CURL_SEARCH_PAGE_CONTEXT_ID = CurlUIIDs.ID_PLUGIN + ".CurlSearchPageContextID";   //$NON-NLS-1$
    /**
     * Launch configuration and debug attributes
     */
    public static final String ID_CURL_DEBUG_MODEL = CurlUIIDs.ID_PLUGIN + ".DebugModel";    //$NON-NLS-1$
    public static final String ATTR_START_FILE_NAME = CurlUIIDs.ID_PLUGIN + ".START_FILE_NAME";   //$NON-NLS-1$
    public static final String ATTR_PROJECT_NAME = CurlUIIDs.ID_PLUGIN + ".PROJECT_NAME";   //$NON-NLS-1$
    public static final String ATTR_DEBUG_JIT_MODE = CurlUIIDs.ID_PLUGIN + "DEBUG_JIT_MODE";   //$NON-NLS-1$
    public static final String ATTR_DEBUG_APPLET_ID = CurlUIIDs.ID_PLUGIN + "DEBUG_APPLET_ID";   //$NON-NLS-1$
    public static final String ATTR_DEBUG_ENGINE_ID = CurlUIIDs.ID_PLUGIN + "DEBUG_ENGINE_ID";   //$NON-NLS-1$
    public static final String ATTR_DEBUG_CONTAINING_TYPE_NAME = "com.curl.eclipse.debug.breakpoint.containingtypeName"; //$NON-NLS-1$
    public static final String ATTR_DEBUG_CONDITION = "com.curl.eclipse.debug.breakpoint.condition"; //$NON-NLS-1$
    public static final String ATTR_DEBUG_NON_WORKSPACE_RESOURCE_NAME = "com.curl.eclipse.debug.breakpoint.non-workspace-resource-name"; //$NON-NLS-1$
    public static final String ATTR_EXCEPTION_TYPE_NAME = "com.curl.eclipse.debug.breakpoint.exceptionTypeName"; //$NON-NLS-1$
    public static final String ATTR_APPLET_FILE_FULL_PATH = CurlUIIDs.ID_PLUGIN + ".START_FILE_FULL_PATH";   //$NON-NLS-1$
    public static final String COLUMN_NUMBER_ATTRIBUTE_NAME_MARKER = "curl-row-number"; //$NON-NLS-1$
    
    /**
     * Help context ids
     */
    public static final String OPEN_ACTION = ID_PLUGIN + "open_action"; //$NON-NLS-1$
    public static final String CURL_PROXY_PREFIX = "curl://eclipseproxy/"; //$NON-NLS-1$

    /**
     * ids also defined in the curl source code
     */
    public static final String TOOL_ID_VISUAL_LAYOUT_EDITOR = "visual-layout-editor"; //$NON-NLS-1$
    public static final String TOOL_ID_VISUAL_LAYOUT_EXT_EDITOR = "vle-extension-editor"; //$NON-NLS-1$
    public static final String TOOL_ID_INTEGRATED_TEXT_EDITOR = "internal-source-editor"; //$NON-NLS-1$
    public static final String TOOL_ID_COVERAGE_VIEWER = "coverage-viewer"; //$NON-NLS-1$
    public static final String TOOL_ID_HTTP_MONITOR = "http-monitor"; //$NON-NLS-1$
    public static final String TOOL_ID_PROFILE_VIEWER = "profile-viewer"; //$NON-NLS-1$
    public static final String ID_CURL_APPLICATION = "com.curl.eclipse.debug.CurlAppletLaunchConfigType"; //$NON-NLS-1$
}
