/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.util;

import java.io.*;
import java.util.Properties;
import com.curl.eclipse.CurlPlugin;

public class CurlProperties
{
    private static Properties fCurlProperties;

    private static void init()
    {
        fCurlProperties = new Properties();
        try {
            fCurlProperties.load(new FileInputStream(CurlPlugin.getDefault().getCurlPropertyFile()));
        } catch (IOException e) {
            CoreUtil.logError("Property file is not found.", e); //$NON-NLS-1$
        }
    }

    public static String getProperty(
            String key, String defaultValue)
    {
        if (fCurlProperties == null)
            CurlProperties.init();
        return fCurlProperties.getProperty(key, defaultValue);
    }

    public static String getProperty(
            String key)
    {
        return getProperty(key, ""); //$NON-NLS-1$
    }
}
