/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.util;

import java.net.URL;
import java.util.HashMap;

import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.ImageData;
import org.osgi.framework.Bundle;

import com.curl.eclipse.CurlPlugin;

/**
 * @author fmisiak
 * see org.eclipse.jdt.internal.ui.JavaPluginImages
 */
public class CurlPluginImages
{
        public static final IPath ICONS_PATH = new Path("icons"); //$NON-NLS-1$

        private static final String NAME_PREFIX= "curl.eclipse.ui."; //$NON-NLS-1$
        private static final int    NAME_PREFIX_LENGTH= NAME_PREFIX.length();

        private static ImageRegistry fgImageRegistry= null;
        private static HashMap<String, ImageDescriptor> fgAvoidSWTErrorMap= null;
        
        private static final String T_OBJ= "obj16";         //$NON-NLS-1$
        private static final String T_OVR= "ovr16";         //$NON-NLS-1$

        
        public static final String IMG_OBJS_SEARCH_DECL= NAME_PREFIX + "search_decl_obj.gif";     //$NON-NLS-1$
        public static final String IMG_OBJS_CUSTOM_EDITOR= NAME_PREFIX + "custom-editor.gif";     //$NON-NLS-1$
        
        public static final String IMG_FIELD_PRIVATE= NAME_PREFIX + "field_private_obj.gif";        //$NON-NLS-1$
        public static final String IMG_FIELD_HIDDEN = NAME_PREFIX + "field_hidden_obj.gif";        //$NON-NLS-1$
        public static final String IMG_FIELD_PACKAGE = NAME_PREFIX + "field_package_obj.gif";        //$NON-NLS-1$
        public static final String IMG_FIELD_PROTECTED = NAME_PREFIX + "field_protected_obj.gif";        //$NON-NLS-1$
        public static final String IMG_FIELD_PUBLIC = NAME_PREFIX + "field_public_obj.gif";        //$NON-NLS-1$

        public static final String IMG_PROC_PRIVATE = NAME_PREFIX + "proc_private_obj.gif";        //$NON-NLS-1$
        public static final String IMG_PROC_HIDDEN = NAME_PREFIX + "proc_hidden_obj.gif";        //$NON-NLS-1$
        public static final String IMG_PROC_PACKAGE = NAME_PREFIX + "proc_package_obj.gif";        //$NON-NLS-1$
        public static final String IMG_PROC_PUBLIC = NAME_PREFIX + "proc_public_obj.gif";        //$NON-NLS-1$

        public static final String IMG_MACRO_HIDDEN = NAME_PREFIX + "macro_hidden_obj.gif";        //$NON-NLS-1$
        public static final String IMG_MACRO_PACKAGE = NAME_PREFIX + "macro_package_obj.gif";        //$NON-NLS-1$
        public static final String IMG_MACRO_PUBLIC = NAME_PREFIX + "macro_public_obj.gif";        //$NON-NLS-1$

        public static final String IMG_CLASS_HIDDEN = NAME_PREFIX + "class_hidden_obj.gif";        //$NON-NLS-1$
        public static final String IMG_CLASS_PACKAGE = NAME_PREFIX + "class_package_obj.gif";        //$NON-NLS-1$
        public static final String IMG_CLASS_PROTECTED = NAME_PREFIX + "class_protected_obj.gif";        //$NON-NLS-1$
        public static final String IMG_CLASS_PUBLIC = NAME_PREFIX + "class_public_obj.gif";        //$NON-NLS-1$

        public static final String IMG_ENUM_HIDDEN = NAME_PREFIX + "enum_hidden_obj.gif";        //$NON-NLS-1$
        public static final String IMG_ENUM_PACKAGE = NAME_PREFIX + "enum_package_obj.gif";        //$NON-NLS-1$
        public static final String IMG_ENUM_PUBLIC = NAME_PREFIX + "enum_public_obj.gif";        //$NON-NLS-1$

        public static final String IMG_METH_PRIVATE= NAME_PREFIX + "meth_private_obj.gif";        //$NON-NLS-1$
        public static final String IMG_METH_HIDDEN = NAME_PREFIX + "meth_hidden_obj.gif";        //$NON-NLS-1$
        public static final String IMG_METH_PACKAGE = NAME_PREFIX + "meth_package_obj.gif";        //$NON-NLS-1$
        public static final String IMG_METH_PROTECTED = NAME_PREFIX + "meth_protected_obj.gif";        //$NON-NLS-1$
        public static final String IMG_METH_PUBLIC = NAME_PREFIX + "meth_public_obj.gif";        //$NON-NLS-1$

        public static final ImageDescriptor DESC_OBJS_SEARCH_DECL= createManagedFromKey(T_OBJ, IMG_OBJS_SEARCH_DECL);
        public static final ImageDescriptor DESC_OBJS_CUSTOM_EDITOR= createManagedFromKey(T_OBJ, IMG_OBJS_CUSTOM_EDITOR);

        public static final ImageDescriptor DESC_PROC_PRIVATE= createManagedFromKey(T_OBJ, IMG_PROC_PRIVATE); 
        public static final ImageDescriptor DESC_PROC_HIDDEN= createManagedFromKey(T_OBJ, IMG_PROC_HIDDEN); 
        public static final ImageDescriptor DESC_PROC_PACKAGE= createManagedFromKey(T_OBJ, IMG_PROC_PACKAGE); 
        public static final ImageDescriptor DESC_PROC_PUBLIC= createManagedFromKey(T_OBJ, IMG_PROC_PUBLIC); 

        public static final ImageDescriptor DESC_MACRO_HIDDEN= createManagedFromKey(T_OBJ, IMG_MACRO_HIDDEN); 
        public static final ImageDescriptor DESC_MACRO_PACKAGE= createManagedFromKey(T_OBJ, IMG_MACRO_PACKAGE); 
        public static final ImageDescriptor DESC_MACRO_PUBLIC= createManagedFromKey(T_OBJ, IMG_MACRO_PUBLIC); 

        public static final ImageDescriptor DESC_CLASS_HIDDEN= createManagedFromKey(T_OBJ, IMG_CLASS_HIDDEN); 
        public static final ImageDescriptor DESC_CLASS_PACKAGE= createManagedFromKey(T_OBJ, IMG_CLASS_PACKAGE); 
        public static final ImageDescriptor DESC_CLASS_PROTECTED= createManagedFromKey(T_OBJ, IMG_CLASS_PROTECTED); 
        public static final ImageDescriptor DESC_CLASS_PUBLIC= createManagedFromKey(T_OBJ, IMG_CLASS_PUBLIC); 

        public static final ImageDescriptor DESC_ENUM_HIDDEN= createManagedFromKey(T_OBJ, IMG_ENUM_HIDDEN); 
        public static final ImageDescriptor DESC_ENUM_PACKAGE= createManagedFromKey(T_OBJ, IMG_ENUM_PACKAGE); 
        public static final ImageDescriptor DESC_ENUM_PUBLIC= createManagedFromKey(T_OBJ, IMG_ENUM_PUBLIC); 

        public static final ImageDescriptor DESC_METH_PRIVATE= createManagedFromKey(T_OBJ, IMG_METH_PRIVATE); 
        public static final ImageDescriptor DESC_METH_HIDDEN= createManagedFromKey(T_OBJ, IMG_METH_HIDDEN); 
        public static final ImageDescriptor DESC_METH_PACKAGE= createManagedFromKey(T_OBJ, IMG_METH_PACKAGE); 
        public static final ImageDescriptor DESC_METH_PROTECTED= createManagedFromKey(T_OBJ, IMG_METH_PROTECTED); 
        public static final ImageDescriptor DESC_METH_PUBLIC= createManagedFromKey(T_OBJ, IMG_METH_PUBLIC); 

        public static final ImageDescriptor DESC_FIELD_PRIVATE= createManagedFromKey(T_OBJ, IMG_FIELD_PRIVATE); 
        public static final ImageDescriptor DESC_FIELD_HIDDEN= createManagedFromKey(T_OBJ, IMG_FIELD_HIDDEN); 
        public static final ImageDescriptor DESC_FIELD_PACKAGE= createManagedFromKey(T_OBJ, IMG_FIELD_PACKAGE); 
        public static final ImageDescriptor DESC_FIELD_PROTECTED= createManagedFromKey(T_OBJ, IMG_FIELD_PROTECTED); 
        public static final ImageDescriptor DESC_FIELD_PUBLIC= createManagedFromKey(T_OBJ, IMG_FIELD_PUBLIC); 

        public static final ImageDescriptor DESC_OVR_CONSTRUCTOR= createUnManagedCached(T_OVR, "constr_ovr.gif");           //$NON-NLS-1$
        public static final ImageDescriptor DESC_OVR_DEPRECATED= createUnManagedCached(T_OVR, "deprecated.gif");            //$NON-NLS-1$
        public static final ImageDescriptor DESC_OVR_CLASS= createUnManagedCached(T_OVR, "class_tsk.gif"); //$NON-NLS-1$
        public static final ImageDescriptor DESC_OVR_ABSTRACT_CLASS= createUnManagedCached(T_OVR, "class_abs_tsk.gif"); //$NON-NLS-1$

        public static final ImageDescriptor DESC_OVR_CONSTANT= createUnManagedCached(T_OVR, "constant_co.gif");                         //$NON-NLS-1$
        public static final ImageDescriptor DESC_OVR_FINAL= createUnManagedCached(T_OVR, "final_co.gif");                       //$NON-NLS-1$
        public static final ImageDescriptor DESC_OVR_ABSTRACT= createUnManagedCached(T_OVR, "abstract_co.gif");                     //$NON-NLS-1$
        public static final ImageDescriptor DESC_OVR_SYNCH= createUnManagedCached(T_OVR, "synch_co.gif");                       //$NON-NLS-1$
        public static final ImageDescriptor DESC_OVR_VOLATILE= createUnManagedCached(T_OVR, "volatile_co.gif");                         //$NON-NLS-1$
        public static final ImageDescriptor DESC_OVR_TRANSIENT= createUnManagedCached(T_OVR, "transient_co.gif");                       //$NON-NLS-1$
        public static final ImageDescriptor DESC_OVR_IMPLICIT= createUnManagedCached(T_OVR, "impli_co.gif");                //$NON-NLS-1$
        public static final ImageDescriptor DESC_OVR_INLINE= createUnManagedCached(T_OVR, "inline_co.gif");                //$NON-NLS-1$
        public static final ImageDescriptor DESC_OVR_SEALED= createUnManagedCached(T_OVR, "sealed_co.gif");                //$NON-NLS-1$
        public static final ImageDescriptor DESC_OVR_WEAK= createUnManagedCached(T_OVR, "weak_co.gif");                //$NON-NLS-1$

        private static ImageDescriptor createManagedFromKey(String prefix, String key) {
            return createManaged(prefix, key.substring(NAME_PREFIX_LENGTH), key);
        }
        
        private static ImageDescriptor createManaged(String prefix, String name, String key) {
            ImageDescriptor result= create(prefix, name, true);
            
            if (fgAvoidSWTErrorMap == null) {
                fgAvoidSWTErrorMap= new HashMap<String, ImageDescriptor>();
            }
            fgAvoidSWTErrorMap.put(key, result);
            if (fgImageRegistry != null) {
                CoreUtil.logError("Image registry already defined"); //$NON-NLS-1$
            }
            return result;
        }
        
        private static ImageDescriptor create(String prefix, String name, boolean useMissingImageDescriptor) {
            IPath path= ICONS_PATH.append(prefix).append(name);
            return createImageDescriptor(CurlPlugin.getDefault().getBundle(), path, useMissingImageDescriptor);
        }
        
        public static ImageDescriptor createImageDescriptor(Bundle bundle, IPath path, boolean useMissingImageDescriptor) {
            URL url= FileLocator.find(bundle, path, null);
            if (url != null) {
                return ImageDescriptor.createFromURL(url);
            }
            if (useMissingImageDescriptor) {
                return ImageDescriptor.getMissingImageDescriptor();
            }
            return null;
        }
        
        static ImageRegistry getImageRegistry() {
            if (fgImageRegistry == null) {
                fgImageRegistry= new ImageRegistry();
                for (String key : fgAvoidSWTErrorMap.keySet()) {
                    fgImageRegistry.put(key, fgAvoidSWTErrorMap.get(key));
                }
                fgAvoidSWTErrorMap= null;
            }
            return fgImageRegistry;
        }
        
        /*
         * Creates an image descriptor for the given prefix and name in the JDT UI bundle and let tye descriptor cache the image data.
         * If no image could be found, the 'missing image descriptor' is returned.
         */
        private static ImageDescriptor createUnManagedCached(String prefix, String name) {
            return new CachedImageDescriptor(create(prefix, name, true));
        }

        private static final class CachedImageDescriptor extends ImageDescriptor {
            private final ImageDescriptor fDescriptor;
            private ImageData fData;

            public CachedImageDescriptor(ImageDescriptor descriptor) {
                fDescriptor = descriptor;
            }

            @Override
            public ImageData getImageData() {
                if (fData == null) {
                    fData= fDescriptor.getImageData();
                }
                return fData;
            }
        }
}
