/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.util;

import org.eclipse.core.runtime.ListenerList;

/**
 * Event manager for delivering Curl specific events.
 */
public abstract class CurlEventManager
{
    private ListenerList fListeners;

    public void dispose()
    {
        if (fListeners != null && !fListeners.isEmpty()) {
            Object[] listeners = fListeners.getListeners();
            for (int i = 0; i < listeners.length; i++) {
                removeListener((ICurlEventListener)listeners[i]);
            }
            fListeners = null;
        }
    }

    public void addListener(
            ICurlEventListener listener)
    {
        if (fListeners == null) {
            fListeners = new ListenerList();
        }
        fListeners.add(listener);
    }

    public void removeListener(
            ICurlEventListener listener)
    {
        if (fListeners != null) {
            fListeners.remove(listener);
        }
    }

    public void fireEvent(
            ICurlEvent event)
    {
        if (fListeners != null && !fListeners.isEmpty()) {
            Object[] listeners = fListeners.getListeners();
            for (int i = 0; i < listeners.length; i++) {
                ((ICurlEventListener)listeners[i]).reactToCurlEvent(event);
            }
        }
    }
}
