/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.util;

import org.eclipse.swt.graphics.Image;

/**
 * Represents a displayable Curl element such as a Curl project, or a source file, etc.
 */
class CurlElement
{
    private final String fLabel;
    private final Image fImage;

    public CurlElement(
            String name,
            Image image)
    {
        fLabel = name;
        fImage = image;
    }

    public String getLabel()
    {
        return fLabel;
    }

    public Image getImage()
    {
        return fImage;
    }

    @Override
    public String toString()
    {
        return fLabel;
    }
}
