/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.search;

import java.util.Comparator;

import org.eclipse.ui.IWorkingSet;

import com.ibm.icu.text.Collator;

public class WorkingSetComparator implements Comparator<IWorkingSet> {

    private Collator fCollator= Collator.getInstance();
   
    /* (non-Javadoc)
     * @see java.util.Comparator#compare(T, T)
     */
    public int compare(
            IWorkingSet ws1,
            IWorkingSet ws2)
    {
        return fCollator.compare(ws1.getLabel(), ws2.getLabel());
    }
}
