/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
/*******************************************************************************
 * Copyright (c) 2000, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package com.curl.eclipse.search;

import org.eclipse.core.runtime.Assert;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.OpenEvent;

import org.eclipse.ui.IViewPart;
import org.eclipse.ui.actions.ActionGroup;

import com.curl.eclipse.actions.OpenEditorActionGroup;
import com.curl.eclipse.actions.OpenViewActionGroup;

/**
 * @author fmisiak
 *
 * see org.eclipse.jdt.internal.ui.search.NewSearchViewActionGroup
 */
class NewSearchViewActionGroup extends com.curl.eclipse.actions.CompositeActionGroup {
	private OpenEditorActionGroup fOpenEditorActionGroup;
	
	public NewSearchViewActionGroup(IViewPart part) {
		Assert.isNotNull(part);
		OpenViewActionGroup openViewActionGroup;
		setGroups(new ActionGroup[]{
			fOpenEditorActionGroup= new OpenEditorActionGroup(part),
            openViewActionGroup= new OpenViewActionGroup(part),
//			 new OpenViewActionGroup(part),
//			new GenerateActionGroup(part), 
//			new RefactorActionGroup(part),
//			new JavaSearchActionGroup(part) 
		});
		openViewActionGroup.containsShowInMenu(false);
	}
	
	public void handleOpen(OpenEvent event) {
		IAction openAction= fOpenEditorActionGroup.getOpenAction();
		if (openAction != null && openAction.isEnabled()) {
			openAction.run();
			return;
		}
	}
}

