/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.search;

import org.eclipse.search.core.text.TextSearchScope;

/**
 * @author fmisiak
 *
 */
class DefinitionQuerySpecification
{

    private final boolean fIsCaseSensitive;
    private final String fSearchText;
    private final TextSearchScope fScope;
    private final String fSearchFor;
    private final String fRegExpPattern;
    private final String fScopeDescription;

    DefinitionQuerySpecification(
            String searchFor,
            String searchText,
            TextSearchScope scope,
            String scopeDescription,
            boolean isCaseSensitive)
    {
        fSearchFor = searchFor;
        fSearchText = searchText;
        fRegExpPattern = toRegExpPattern(searchText);
        fIsCaseSensitive = isCaseSensitive;
        fScope = scope;
        fScopeDescription = scopeDescription;
    }

    private String toRegExpPattern(
            String pattern)
    {
        return "^" + pattern.replaceAll("\\*", ".*").replaceAll("\\!", ".").replace("?", "\\?") + "$"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$
    }


    public boolean isCaseSensitive()
    {
        return fIsCaseSensitive;
    }

    public String getRegExpPattern()
    {
        return fRegExpPattern;
    }
    
    public String getSearchText()
    {
        return fSearchText;
    }

    public TextSearchScope getScope()
    {
        return fScope;
    }

    public String getScopeDescription()
    {
        return fScopeDescription;
    }
    
    public String getSearchFor()
    {
        return fSearchFor;
    }
}
