/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.search;

import java.util.HashSet;
import java.util.Iterator;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.ui.IWorkingSet;


public class CurlSearchScopeFactory
{

    private static final String[] curlFileExtensions = { "*.*curl", }; //$NON-NLS-1$

    private static CurlSearchScopeFactory fgInstance;

    public static CurlSearchScopeFactory getInstance()
    {
        if (fgInstance == null)
            fgInstance= new CurlSearchScopeFactory();
        return fgInstance;
    }
    
    FileTextSearchScope getSelectedResourcesScope(ISelection sel)
    {
        HashSet<IResource> resources = new HashSet<IResource>();
        if (sel instanceof IStructuredSelection && !sel.isEmpty()) {
            @SuppressWarnings("unchecked") 
            Iterator iter = ((IStructuredSelection)sel).iterator();
            while (iter.hasNext()) {
                Object curr = iter.next();
                if (curr instanceof IWorkingSet) {
                    IWorkingSet workingSet = (IWorkingSet)curr;
                    if (workingSet.isAggregateWorkingSet() && workingSet.isEmpty()) {
                        return FileTextSearchScope.newWorkspaceScope(curlFileExtensions, false);
                    }
                    IAdaptable[] elements = workingSet.getElements();
                    for (int i = 0; i < elements.length; i++) {
                        IResource resource = (IResource)elements[i].getAdapter(IResource.class);
                        if (resource != null && resource.isAccessible()) {
                            resources.add(resource);
                        }
                    }
                } else if (curr instanceof IAdaptable) {
                    IResource resource = (IResource)((IAdaptable)curr).getAdapter(IResource.class);
                    if (resource != null && resource.isAccessible()) {
                        resources.add(resource);
                    }
                }
            }
        }
        IResource[] arr = resources.toArray(new IResource[resources.size()]);
        return FileTextSearchScope.newSearchScope(arr, curlFileExtensions, false);
    }

    public FileTextSearchScope createWorkspaceScope()
    {
        return  FileTextSearchScope.newWorkspaceScope(curlFileExtensions, false);
    }

    public FileTextSearchScope createCurlSearchScope(
            IWorkingSet[] workingSets)
    {
        return  FileTextSearchScope.newSearchScope(workingSets, curlFileExtensions, false);
    }

    public FileTextSearchScope getEnclosingProjectScope(String[] enclosingProjectName)
    {
        if (enclosingProjectName == null) {
            return FileTextSearchScope.newWorkspaceScope(curlFileExtensions, false);
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource[] res = new IResource[enclosingProjectName.length];
        for (int i = 0; i < res.length; i++) {
            res[i] = root.getProject(enclosingProjectName[i]);
        }
        return FileTextSearchScope.newSearchScope(res, curlFileExtensions, false);
    }


}
