/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.search;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.IFileMatchAdapter;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;

/**
 * see org.eclipse.jdt.internal.ui.search.JavaSearchResult
 * 
 * @author fmisiak
 */
public class CurlSearchResult  extends AbstractTextSearchResult 
    implements IEditorMatchAdapter, IFileMatchAdapter
{

    private final CurlSearchDefinitionQuery fQuery;
    private final Match[] EMPTY_ARR= new Match[0];
    
    CurlSearchResult(
            CurlSearchDefinitionQuery curlSearchQuery)
    {
        fQuery = curlSearchQuery;
        /* TODO maybe (see e.g with Java search result view filters, which allows to set filters on things like:
         * - in imports,
         * - in deprecated,
         * -in javadoc,
         * - etc...
         * 
         * This is really useful to filter (exclude) things like import statement
         * see setActiveMatchFilters(JavaMatchFilter.getLastUsedFilters());
         */ 

    }

    public ImageDescriptor getImageDescriptor() {
        return fQuery.getImageDescriptor();
    }

    public String getLabel() {
        return fQuery.getResultLabel(getMatchCount());
    }
    
    public String getTooltip() {
        return getLabel();
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IFile file) {
        return getMatches(file);
    }

    public IFile getFile(Object element) {
        if (element instanceof IFile)
            return (IFile)element;
        return null;
    }

    public boolean isShownInEditor(Match match, IEditorPart editor) {
        IEditorInput ei= editor.getEditorInput();
        if (ei instanceof IFileEditorInput) {
            IFileEditorInput fi= (IFileEditorInput) ei;
            return match.getElement().equals(fi.getFile());
        }
        return false;
    }
    
    public Match[] computeContainedMatches(AbstractTextSearchResult result, IEditorPart editor) {
        IEditorInput ei= editor.getEditorInput();
        if (ei instanceof IFileEditorInput) {
            IFileEditorInput fi= (IFileEditorInput) ei;
            return getMatches(fi.getFile());
        }
        return EMPTY_ARR;
    }

    public ISearchQuery getQuery() {
        return fQuery;
    }
    
    public IFileMatchAdapter getFileMatchAdapter() {
        return this;
    }
    
    public IEditorMatchAdapter getEditorMatchAdapter() {
        return this;
    }
}
