/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.search;

import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

/**
 * @author fmisiak
 * see org.eclipse.jdt.internal.ui.search.JavaSearchContentProvider
 */
abstract class CurlSearchContentProvider implements IStructuredContentProvider
{
    protected final Object[] EMPTY_ARR= new Object[0];

    protected CurlSearchResultPage fPage;
    
    protected CurlSearchResult fResult;

    public CurlSearchContentProvider(
            CurlSearchResultPage page)
    {
        fPage= page;

    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) 
    {
        initialize((CurlSearchResult) newInput);
    }


    protected void initialize(CurlSearchResult result) 
    {
        fResult= result;
    } 

    public void dispose() {
        // nothing to do
    }
    
    public abstract void elementsChanged(Object[] updatedElements);

    public abstract void clear();


}
