/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.search;

import org.eclipse.search.ui.text.Match;

import com.curl.eclipse.core.CurlElement;

/**
 * The basic eclipse Match doesn't allow to deal with row/column,
 * it only allows for offset location.
 * Because we manage the opening of editors and the corresponding 
 * selections in this package,
 * we can rely only on the associated CurlElement to do so.
 */
public class CurlMatch extends Match
{
    public CurlMatch(CurlElement element)
    {
        super(element, computeDummyOffset(element), element.getSymbolName().length());
    }
    
    /**
     * Should only be used to perform sorting of position,
     * not to actually select a position in a document
     * @param row
     * @param col
     * @return
     */
    private static int computeDummyOffset(CurlElement element)
    {
        // 1000 chars per line seems wide enough
        // to avoid collisions in our virtual space of dummy offsets
        return element.getRow() * 1000 + element.getCol();
    }

}
