/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.search;

import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;

/**
 * @author fmisiak
 * see org.eclipse.search.internal.ui.text.FileTableContentProvider.FileTableContentProvider
 */
public class ContentProvider extends CurlSearchContentProvider
    implements IContentProvider, IStructuredContentProvider
{
    public ContentProvider(CurlSearchResultPage page) {
        super(page);
    }
    
    /* (non-Javadoc)
     * @see org.eclipse.jface.viewers.IStructuredContentProvider#getElements(java.lang.Object)
     */
    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof CurlSearchResult) {
            int elementLimit= getElementLimit();
            Object[] elements= ((CurlSearchResult)inputElement).getElements();
            if (elementLimit != -1 && elements.length > elementLimit) {
                Object[] shownElements= new Object[elementLimit];
                System.arraycopy(elements, 0, shownElements, 0, elementLimit);
                return shownElements;
            }
            return elements;
        }
        return EMPTY_ARR;
    }
    
    /* (non-Javadoc)
     * @see com.curl.eclipse.search.CurlSearchContentProvider#elementsChanged(java.lang.Object[])
     */
    public void elementsChanged(Object[] updatedElements) {
        TableViewer viewer= getViewer();
        int elementLimit= getElementLimit();
        boolean tableLimited= elementLimit != -1;
        for (int i= 0; i < updatedElements.length; i++) {
            if (fResult.getMatchCount(updatedElements[i]) > 0) {
                if (viewer.testFindItem(updatedElements[i]) != null)
                    viewer.update(updatedElements[i], null);
                else {
                    if (!tableLimited || viewer.getTable().getItemCount() < elementLimit)
                        viewer.add(updatedElements[i]);
                }
            } else
                viewer.remove(updatedElements[i]);
        }
    }

    private int getElementLimit() {
        return fPage.getElementLimit().intValue();
    }

    private TableViewer getViewer() {
        return (TableViewer) fPage.getViewer();
    }
    
    /* (non-Javadoc)
     * @see com.curl.eclipse.search.CurlSearchContentProvider#clear()
     */
    public void clear() {
        getViewer().refresh();
    }
}
