/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.remote;

import com.curl.eclipse.CurlPlugin;
import com.curl.eclipse.util.CoreUtil;

/**
 * @author fmisiak
 *
 */
abstract class SynchronousRemoteOperation extends RemoteOperation
{
    SynchronousRemoteOperation(
            int commandCode)
    {
        super(commandCode);
    }

    protected abstract void receiveResponse();
    
    final void sendReceive()
    {
        if (!fMediatorConnection.getEclipseServer().isServerRunning()) {
            // Server is not running... nothing to do
            return;
        }
        try {
            sendArguments();
            receiveResponse();
        } catch (Exception e) {
            if (!CurlPlugin.getDefault().isStoppedOrStopping()) {
                CoreUtil.logError("While sending synchronous operation"); //$NON-NLS-1$
            }
            // otherwise plug-in is shutting down, or already shutdown
        }
    }    

    protected int readInt()
    {
        return DataIO.readInt(fInputStream);
    }

    protected String readString()
    {
        return DataIO.readString(fInputStream);
    }

    protected boolean readBoolean()
    {
        return DataIO.readBoolean(fInputStream);
    }

    protected int readUnsignedByte()
    {
        return DataIO.readUnsignedByte(fInputStream);
    }
    
    protected void readOkReply()
    {
        int replyOk = DataIO.readUnsignedByte(fInputStream);
        if (replyOk != 0)
            CoreUtil.logError("Could not reply back."); //$NON-NLS-1$
    }
}
