/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.remote;

import java.io.*;

class StreamRedirect extends Thread
{
    private InputStream is;
    private OutputStream os;

    StreamRedirect(InputStream is, OutputStream redirect) {
        this.is = is;
        this.os = redirect;
        start();
    }

    public void run()
    {
        try {
            PrintWriter pw = new PrintWriter(os);
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            String line = null;
            while ((line = br.readLine()) != null) {
                pw.println(line);
                pw.flush();
            }
        } catch (IOException ioe) {
            // Either the process has died or we've run out of disk space.
        } finally {
            try {
                os.close();
            } catch (IOException ioe) {
                // Ignore error.
            }
        }
    }
}
