/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.remote;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.resources.IFile;

import com.curl.eclipse.CurlPlugin;
import com.curl.eclipse.core.AccessEnum;
import com.curl.eclipse.core.BindingInfo;
import com.curl.eclipse.remote.ICurlSearchDefinitionQueryResultHandler.Match;

/**
 * @author fmisiak
 *
 */
public class SearchResultProxyData extends ProxyData
{

    public SearchResultProxyData(
            Object proxyOf)
    {
        super(proxyOf);
    }

    private static class QueryDefinitionResultsCommand
    {

        public int numberOfFilesScanned;
        public boolean endOfQuery;
        public List<Match> matches;
        
    }
    static
    {
        EclipseServer.register(MediatorConnection.commandQueryDefinitionResults, new QueryDefinitionResultsCommandHandler());
    }
    public static class QueryDefinitionResultsCommandHandler extends ProxyCommandHandler<SearchResultProxyData, QueryDefinitionResultsCommand>
    {
        @Override
        QueryDefinitionResultsCommand decode(
                DataInputStream sockIn)
        {
            QueryDefinitionResultsCommand command = new QueryDefinitionResultsCommand();
            command.numberOfFilesScanned = DataIO.readInt(sockIn);
            int nbMatches = DataIO.readInt(sockIn);
            command.matches = new ArrayList<Match>();
            for (int i = 0; i < nbMatches; i++) {
                Match match = new Match();
                match.fileURL = DataIO.readString(sockIn);
                match.curlElementType = DataIO.readString(sockIn); 
                match.nameOfType = DataIO.readString(sockIn); // curl class name or curl enum name
                match.row = DataIO.readInt(sockIn);
                match.col = DataIO.readInt(sockIn);
                match.symbolName = DataIO.readString(sockIn);
                match.parentRow = DataIO.readInt(sockIn);
                match.parentCol = DataIO.readInt(sockIn);
                match.info = readBindingInfo(sockIn);
                boolean existsInfoParent = DataIO.readBoolean(sockIn);
                if (existsInfoParent) {
                    match.infoParent = readBindingInfo(sockIn);
                    match.curlElementParentType = DataIO.readString(sockIn); 
                }
                command.matches.add(match);
            }
            command.endOfQuery = DataIO.readBoolean(sockIn);
            return command;
        }
        
        private BindingInfo readBindingInfo(
                DataInputStream sockIn)
        {
            BindingInfo info = new BindingInfo();
            info.attributes = DataIO.readInt(sockIn);
            info.access = AccessEnum.fromValue(DataIO.readInt(sockIn));
            info.writeAccess = AccessEnum.fromValue(DataIO.readInt(sockIn));
            return info;
        }

        @Override
        void execute(
                final QueryDefinitionResultsCommand command,
                final SearchResultProxyData proxy,
                DataOutputStream sockOut)
        {
            ICurlSearchDefinitionQueryResultHandler listener = (ICurlSearchDefinitionQueryResultHandler)proxy.fProxyOf;
            listener.setNumberOfFileScanned(command.numberOfFilesScanned);
            for (Match match : command.matches) {
                listener.matchingDefinitionFound(match);
            }
            if (command.endOfQuery) {
                listener.searchCompleted();
            }
        }
    }

    public void queryDefinitions(
            final String searchFor,
            final String searchText,
            final boolean caseSensitive,
            final IFile[] files)
    {
        fMediatorConnection.async.execute(new AsynchronousRemoteOperation(MediatorConnection.commandPerformQueryDefinitions){
            @Override
            protected void writeArguments()
            {
                write(CurlPlugin.getDefault().getWorkbenchProxy().getProxyID());
                write(fProxyID);
                write(searchFor);
                write(searchText);
                write(caseSensitive);
                write(files.length);
                for (IFile file : files) {
                    write(file.getRawLocationURI().toString());
                }
            }
        });
    }
    

    public void cancelQuery()
    {
        asynchronousNoArgsOperation(MediatorConnection.commandPerformCancelQueryDefinitions);
    }
}
