/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.remote;

import java.io.DataInputStream;
import java.io.DataOutputStream;

import com.curl.eclipse.CurlPlugin;

/**
 * @author fmisiak
 * 
 */
abstract class RemoteOperation
{
    private final int fCommandCode;
    protected final DataInputStream fInputStream;
    protected final DataOutputStream fOutputStream;
    protected final MediatorConnection fMediatorConnection;
    protected final long fTransactionId;

    protected RemoteOperation(
            int commandCode)
    {
        fCommandCode = commandCode;
        fMediatorConnection = CurlPlugin.getDefault().getMediatorConnection();
        fInputStream = fMediatorConnection.getInputStream();
        fOutputStream = fMediatorConnection.getOutputStream();
        fTransactionId =  fMediatorConnection.allocateTransactionId();
    }

    protected void write(
            int value)
    {
        DataIO.writeInt(fOutputStream, value);
    }

    protected void write(
            long value)
    {
        DataIO.writeLong(fOutputStream, value);
    }

    protected void write(
            String string)
    {
        DataIO.writeString(fOutputStream, string);
    }

    private void writeUnsignedByte(
            int value)
    {
        DataIO.writeUnsignedByte(fOutputStream, value);
    }

    protected void write(
            boolean value)
    {
        DataIO.writeBoolean(fOutputStream, value);
    }
    
    final void sendArguments()
    {
        writeUnsignedByte(0xCA);
        writeUnsignedByte(0xFE);
        writeUnsignedByte(0xBA);
        writeUnsignedByte(0xBE);
        writeUnsignedByte(fCommandCode);
        write(fTransactionId);
        writeArguments();
        DataIO.flush(fOutputStream);
    }

    protected void writeArguments()
    {
        // no argument by default
    }
}
