/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.remote;

import java.io.DataInputStream;
import java.io.DataOutputStream;

public abstract class ProxyViewSelectionContainer extends ProxyView
{
    private final ICurlViewSelectionListener fSelectionListener;


    protected ProxyViewSelectionContainer(
            ICurlViewSelectionListener proxyOf,
            String viewId)
    {
        super(proxyOf, viewId);
        fSelectionListener = proxyOf;
    }

    
    static
    {
        EclipseServer.register(MediatorConnection.commandSelectionChanged, new SelectionChangedCommandHandler());
    }
    public static class SelectionChangedCommandHandler extends ProxyCommandHandler<ProxyViewSelectionContainer, String>
    {
        @Override
        String decode(
                DataInputStream sockIn)
        {
            return DataIO.readString(sockIn);
        }
        
        @Override
        void execute(
                final String urlString,
                final ProxyViewSelectionContainer proxy,
                DataOutputStream sockOut)
        {
            if (proxy.fSelectionListener != null) {
                proxy.fSelectionListener.selectionChanged(urlString);
            }
        }
    }
}
