/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.remote;

import java.util.HashMap;

import com.curl.eclipse.util.CoreUtil;

/**
 * Manage Proxies:  Add, delete, get, etc.
 */
public class ProxyFactory
{
    // Used to make an agent id. This is used to identify agents (like a handle).
    private static int fAgentIdFactory;
    private static final HashMap<Integer, Proxy> fProxyMap = new HashMap<Integer, Proxy>();

    synchronized static Proxy getProxy(
            int agentId)
    {
        if (ProxyFactory.fProxyMap == null) {
            CoreUtil.logError("View map is null."); //$NON-NLS-1$
            return null;
        }
        return ProxyFactory.fProxyMap.get(new Integer(agentId));
    }

    synchronized public static DebugProxyData getDebugProxyData(
            String appletID)
    {
        for (Proxy proxy : ProxyFactory.fProxyMap.values()) {
            if (proxy instanceof DebugProxyData) {
                DebugProxyData debugProxyData = (DebugProxyData)proxy;
                if (debugProxyData.getAppletID().equals(appletID))
                    return debugProxyData;
            }
        }
        return null;
    }

    // NOTE: this should only be called from the Proxy constructor.
    synchronized static int addProxy(
            Proxy proxy)
    {
        int agentId = fAgentIdFactory++;
        ProxyFactory.fProxyMap.put(new Integer(agentId), proxy);
        return agentId;
    }

    // NOTE: this should only be called from Proxy.destroy.
    synchronized static void removeProxy(
            int proxyId)
    {
        if (ProxyFactory.fProxyMap.remove(proxyId) == null) {
            CoreUtil.logWarning("Trying to remove a proxy already removed, id=" + proxyId); //$NON-NLS-1$
        }
    }
}
