/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.remote;

import java.io.DataInputStream;
import java.io.DataOutputStream;

abstract class ProxyCommandHandler<T extends IProxy, S>
{
    S decode(
            DataInputStream sockIn)
    {
        // by default no specific parameters
        return null;
    }
    
    
    abstract void execute(
            S command,
            T proxy,
            DataOutputStream sockOut);
}

/**
 * Used for command not requiring any parameters.
 */
class NullProxyCommand
{
    
}

abstract class NoArgsProxyCommandHandler<T extends IProxy> extends ProxyCommandHandler<T, NullProxyCommand>
{
    abstract void execute(T Proxy, DataOutputStream sockOut);
    
    @Override
    void execute(
            NullProxyCommand command,
            T proxy,
            DataOutputStream sockOut)
    {
        execute(proxy, sockOut);
    }
}