/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.remote;

import org.eclipse.swt.widgets.Composite;

public class ProjectCreationWizardViewProxy extends DialogViewProxy
{
    private final String fWorkspaceFullPath;

    public ProjectCreationWizardViewProxy(
            Object proxyOf,
            String workspaceFullPath)
    {
        super(proxyOf);
        fWorkspaceFullPath = workspaceFullPath;
    }

    public void createViewForDialog(
            final Composite composite)
    {
        fMediatorConnection.async.execute(
                new CreateViewRemoteOperation(MediatorConnection.commandMakeProjectCreationWizardView, composite) {
            @Override
            protected void writeViewArguments()
            {
                write(fWorkspaceFullPath);
            }
        });
        fViewExists = true;
    }

    public boolean performValidation(
            final StringBuffer projectNameReturnedFromMediator,
            final StringBuffer directoryFullPathReturnedFromMediator,
            final StringBuffer dirIsInWorkspaceReturnedFromMediator)
    {
        final boolean[] success = new boolean[1];
        fMediatorConnection.sync.executeInModalContext(new SynchronousRemoteOperation(MediatorConnection.commandPerformDialogValidation) {
            @Override
            protected void writeArguments()
            {
                write(fProxyID);
            }

            @Override
            protected void receiveResponse()
            {
                success[0] = readUnsignedByte() == MediatorConnection.commandSuccess;
                if (success[0]) {
                    String projectName = readString();
                    String dirFullPath = readString();
                    String inWorkspace = readString();
                    projectNameReturnedFromMediator.insert(0, projectName);
                    directoryFullPathReturnedFromMediator.insert(0, dirFullPath);
                    dirIsInWorkspaceReturnedFromMediator.insert(0, inWorkspace);
                }
            }
        });
        return success[0];
    }
    
    public boolean createProject()
    {
        final boolean[] success = new boolean[1];
        fMediatorConnection.sync.executeInModalContext(new SynchronousRemoteOperation(MediatorConnection.commandCreateResource) {
            @Override
            protected void writeArguments()
            {
                write(fProxyID);
            }
            @Override
            protected void receiveResponse()
            {
                success[0] = readUnsignedByte() == MediatorConnection.commandSuccess;
            }
        });
        return success[0];
    }
    
}
