/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.remote;

import org.eclipse.swt.widgets.Composite;

public class NewFileWizardViewProxy extends DialogViewProxy
{
    private final String fSelectedDirFullPath;
    private final boolean fCreatePackageMode;

    public NewFileWizardViewProxy(
            Object proxyOf,
            String selectedDirFullPath,
            boolean createPackage)
    {
        super(proxyOf);
        fSelectedDirFullPath = selectedDirFullPath;
        fCreatePackageMode = createPackage;
    }

    @Override
    public void createViewForDialog(
            final Composite composite)
    {
        fMediatorConnection.async.execute(
                new CreateViewRemoteOperation(MediatorConnection.commandMakeFileWizardView, composite) {
            @Override
            protected void writeViewArguments()
            {
                write(fSelectedDirFullPath);
                write(fCreatePackageMode ? MediatorConnection.subcommandForPackage
                        : MediatorConnection.subcommandForSourceFile);
            }
        });
        fViewExists = true;
    }

    public boolean validateAndCreateFile(
            final StringBuffer sourceFileURIReturnedFromMediator)
    {
        final boolean status[] = new boolean[1];
        fMediatorConnection.sync.executeInModalContext(new SynchronousRemoteOperation(MediatorConnection.commandPerformDialogValidation) {
            @Override
            protected void writeArguments()
            {
                write(fProxyID);
            }

            @Override
            protected void receiveResponse()
            {
                int success = readUnsignedByte();
                if (success == MediatorConnection.commandSuccess) {
                    String sourceFileNameURI = readString();
                    sourceFileURIReturnedFromMediator.insert(0, sourceFileNameURI);
                    status[0] = true;
                }
            }
        });

        return status[0];
    }
}