/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.remote;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchWindow;

import com.curl.eclipse.editors.CurlManifestExplorerView;
import com.curl.eclipse.util.CurlUIIDs;

/*
 * Manage a proxy for a source view.
 */
public class ManifestExplorerViewProxy extends ProxyViewSelectionContainer
{
    public ManifestExplorerViewProxy(CurlManifestExplorerView proxyOf) {
        super(proxyOf, CurlUIIDs.ID_CURL_MANIFEST_EXPLORER);
    }
    
    @Override
    public CurlManifestExplorerView getProxyOf()
    {
        return (CurlManifestExplorerView) super.getProxyOf();
    }

    @Override
    public void createRemoteView(
            IWorkbenchWindow workbenchWindow,
            Composite composite)
    {
        createView(workbenchWindow, composite, MediatorConnection.commandMakeManifestExplorerView);
    }
        
    @Override
    protected Menu getContextMenu()
    {
        return getProxyOf().getContextMenu();
    }
}
