/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.remote;

import java.io.DataInputStream;
import java.io.DataOutputStream;

/**
 * TODO: Comment...
 */
public interface INotifyCommandChangedProxy extends IProxy
{

    void setOperationStatus(
            int commandId,
            boolean enabled,
            boolean value,
            String label);

    /**
     * Read the enabled/disabled state of a command
     */
    public static class NotifyCommandChangedCommand
    {
        public int commandId;
        public boolean enabled;
        public boolean value;
        public String label;
    }
    public static class NotifyCommandChangedCommandHandler extends ProxyCommandHandler<INotifyCommandChangedProxy, NotifyCommandChangedCommand>
    {
        @Override
        NotifyCommandChangedCommand decode(
                DataInputStream sockIn)
        {
            NotifyCommandChangedCommand command = new NotifyCommandChangedCommand();
            command.commandId = DataIO.readInt(sockIn);
            command.enabled = DataIO.readBoolean(sockIn);
            command.value = DataIO.readBoolean(sockIn);
            command.label = DataIO.readString(sockIn);
            return command;
        }
        
        @Override
        void execute(
                final NotifyCommandChangedCommand command,
                final INotifyCommandChangedProxy proxy,
                DataOutputStream sockOut)
        {
            proxy.setOperationStatus(command.commandId, command.enabled, command.value, command.label);
        }
    }            
    
}
