/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.remote;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Composite;

import com.curl.eclipse.editors.CurlContentOutlinePage;

/*
 * Manage a proxy view for creating a Curl editor outline.
 */
public class EditorOutlineViewProxy extends ProxyViewSelectionContainer
{
//    private SourceViewProxy fAssociatedEditorProxy;

    public EditorOutlineViewProxy(
            ICurlViewSelectionListener proxyOf)
    {
        super(proxyOf, null);
    }

    public void createOutline(
            final SourceViewProxy associatedEditorProxy,
            final Composite composite,
            IProgressMonitor progressMonitor)
    {
        fMediatorConnection.async.execute(
                new CreateViewRemoteOperation(MediatorConnection.commandMakeEditorOutlineView, composite) {
            @Override
            protected void writeViewArguments()
            {
                write(associatedEditorProxy.getProxyID());
            }
        });
        fViewExists = true;
    }

    public void resizeOutline(
            final Composite composite)
    {
        resizeView(composite);
    }

    public void showOutlineView(
            final Composite composite)
    {
        if (!composite.isDisposed() && fProxyID != 0 && fViewExists) {
            asynchronousNoArgsOperation(MediatorConnection.commandShowOutlineView);
        }
    }

    public void hideOutlineView(
            final Composite composite)
    {
        if (!composite.isDisposed() && fProxyID != 0 && fViewExists) {
            asynchronousNoArgsOperation(MediatorConnection.commandHideOutlineView);
        }
    }

    @Override
    protected void activateParentView()
    {
        CurlContentOutlinePage page = (CurlContentOutlinePage) fProxyOf;
        page.activateParentView();
    }
}
