/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.remote;

import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;

/*
 * Manage a dialog page proxy.
 */
public abstract class DialogViewProxy extends ProxyView
{
    DialogViewProxy(
            Object proxyOf)
    {
        super(proxyOf, 
                null); // modal dialog don't require focus management (so far)
    }

    public void resizePage(
            Composite composite)
    {
        resizeView(composite);
    }

    public boolean performValidation()
    {
        final boolean[] result = new boolean[1];
        fMediatorConnection.sync.executeInModalContext(new SynchronousRemoteOperation(MediatorConnection.commandPerformDialogValidation) {
            @Override
            protected void writeArguments()
            {
                write(fProxyID);
            }
            @Override
            protected void receiveResponse()
            {
                result[0] = readUnsignedByte() == MediatorConnection.commandSuccess;
            }
        });
        return result[0];
    }

    public void performCommit()
    {
        asynchronousNoArgsOperation(MediatorConnection.commandPerformDialogCommit);
    }

    public void createViewForDialog(
            Composite composite) 
    {
        // TODO:  Ugly.  Not all subclasses have to implement this.
        // Here to avoid casts.  Someday create a subclass between
        // this class and the project related proxy classes.
        return;
    }
    
    public void createViewForProjectPropertiesPage(
            final Composite composite,
            final String projectUrl,
            final int viewKind)
    {
        fMediatorConnection.async.execute(new CreateViewRemoteOperation(viewKind, composite) {
            @Override
            protected void writeViewArguments()
            {
                write(projectUrl);
            }
        });
        fViewExists = true;
    }
    
    @Override
    protected boolean processIfTopLevelEvent(Event event)
    {
        // On Linux we will not be psoting these KeyPresses because
        // we get into an infinite loop.
        if (Platform.getOS().equals(Platform.OS_LINUX)) {
            return false;
        }
        
        Display display = fComposite.getDisplay();
        fComposite.forceFocus();
        while (!display.readAndDispatch()) {};
            
        if (event.stateMask == SWT.ALT || event.keyCode == SWT.ESC) {
            final Event ae = new Event();
            ae.keyCode = event.stateMask;
            ae.type = SWT.KeyDown;
            ae.doit = true;
            if (event.keyCode == SWT.ESC) {
                ae.detail = SWT.TRAVERSE_ESCAPE;
            } else {
                ae.detail = SWT.TRAVERSE_MNEMONIC;
            }
            display.post(ae);
            while (!display.readAndDispatch()) {};
        }
        display.post(event);
        while (!display.readAndDispatch()) {};
        fComposite.setFocus();
        return true;
    }
}
