/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.remote;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchWindow;

import com.curl.eclipse.util.CurlUIIDs;


/*
 * Manage a proxy for a source view.
 */
public class DefinitionsViewProxy extends ProxyViewSelectionContainer
{
    public DefinitionsViewProxy(ICurlViewSelectionListener proxyOf) {
        super(proxyOf, CurlUIIDs.ID_CURL_DEFINITIONS);
    }

    @Override
    public void createRemoteView(
            IWorkbenchWindow workbenchWindow,
            Composite composite)
    {
        createView(workbenchWindow, composite, MediatorConnection.commandMakeDefinitionsView);
    }
}
