/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.remote;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import com.curl.eclipse.util.CoreUtil;

// Low level data io manager.  Any errors are caught and reported in the log.
public class DataIO
{
    public static String IPName = "localhost"; //$NON-NLS-1$

    // Read an int
    public static int readUnsignedByte(
            DataInputStream sockIn)
    {
        int theInt = -1;
        if (sockIn != null) {
            try {
                theInt = sockIn.readUnsignedByte();
            } catch (IOException e) {
                CoreUtil.logError("Read unsigned byte failed", e); //$NON-NLS-1$
                return -1;
            }
        }
        return theInt;
    }

    public static boolean readBoolean(
            DataInputStream sockIn)
    {
        return DataIO.readUnsignedByte(sockIn) != 0;
    }

    // Write an int
    public static void writeUnsignedByte(
            DataOutputStream sockOut,
            int theInt)
    {
        if (sockOut != null) {
            try {
                sockOut.write(theInt);
            } catch (IOException e) {
                CoreUtil.logError("Write unsigned byte failed", e); //$NON-NLS-1$
            }
        }
    }

    // Read an int
    public static short readShort(
            DataInputStream sockIn)
    {
        short theShort = -1;
        if (sockIn != null) {
            try {
                theShort = sockIn.readShort();
            } catch (IOException e) {
                CoreUtil.logError("Read short failed", e); //$NON-NLS-1$
                return -1;
            }
        }
        return theShort;
    }

    // Write an int
    public static void writeShort(
            DataOutputStream sockOut,
            int theShort)
    {
        if (sockOut != null) {
            try {
                sockOut.writeShort(theShort);
            } catch (IOException e) {
                CoreUtil.logError("Write short failed", e); //$NON-NLS-1$
            }
        }
    }

    // Read an int
    public static int readInt(
            DataInputStream sockIn)
    {
        int theInt = -1;
        if (sockIn != null) {
            try {
                theInt = sockIn.readInt();
            } catch (Exception e) {
                // TODO: This could be IOException or EOFException. Should we
                // treat them equally?
                CoreUtil.logError("Read int failed", e); //$NON-NLS-1$
                return -1;
            }
        }
        return theInt;
    }

    public static long readLong(
            DataInputStream sockIn)
    {
        long theLong = -1L;
        if (sockIn != null) {
            try {
                theLong = sockIn.readLong();
            } catch (Exception e) {
                // TODO: This could be IOException or EOFException. Should we
                // treat them equally?
                CoreUtil.logError("Read long failed", e); //$NON-NLS-1$
                return -1L;
            }
        }
        return theLong;
    }
    
    // Write an int
    public static void writeInt(
            DataOutputStream sockOut,
            int theInt)
    {
        if (sockOut != null) {
            try {
                sockOut.writeInt(theInt);
            } catch (IOException e) {
                CoreUtil.logError("Write int failed", e); //$NON-NLS-1$
            }
        }
    }
    
    public static void writeLong(
            DataOutputStream sockOut,
            long theLong)
    {
        if (sockOut != null) {
            try {
                sockOut.writeLong(theLong);
            } catch (IOException e) {
                CoreUtil.logError("Write long failed", e); //$NON-NLS-1$
            }
        }
    }
        
    public static void writeBoolean(
            DataOutputStream sockOut,
            boolean theBoolean)
    {
        if (sockOut != null) {
            try {
                sockOut.writeBoolean(theBoolean);
            } catch (IOException e) {
                CoreUtil.logError("Write boolean failed", e); //$NON-NLS-1$
            }
        }
    }

    // Read a String
    public static String readString(
            DataInputStream sockIn)
    {
        StringBuffer strBuff = new StringBuffer();
        if (sockIn != null) {
            try {
                int charLen = sockIn.readInt();
                if (charLen > 0) {
                    for (int i = 0; i < charLen; i++)
                        strBuff.append(sockIn.readChar());
                }
            } catch (IOException e) {
                CoreUtil.logError("Read String failed", e); //$NON-NLS-1$
                return ""; //$NON-NLS-1$
            }
        }
        return strBuff.toString();
    }

    // Write a String
    public static void writeString(
            DataOutputStream sockOut,
            String str)
    {
        if (str == null) {
            str = ""; //$NON-NLS-1$
        }
        
        if (sockOut != null) {
            try {
                sockOut.writeInt(str.length());
                sockOut.writeChars(str);
            } catch (IOException e) {
                CoreUtil.logError("Write String failed", e); //$NON-NLS-1$
            }
        }
    }

    // Flush the socket
    public static boolean flush(
            DataOutputStream sockOut)
    {
        if (sockOut != null) {
            try {
                sockOut.flush();
            } catch (IOException e) {
                CoreUtil.logError("Flush failed", e); //$NON-NLS-1$
                return false;
            }
        }
        return true;
    }
}
