/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.remote;

import java.io.DataInputStream;
import java.io.DataOutputStream;

import com.curl.eclipse.CurlPlugin;
import com.curl.eclipse.console.CurlConsoleFactory;

/**
 * A proxy data for the Curl console.  This is a proxy of the CurlConsoleFactory.
 */
public class ConsoleProxyData extends ProxyData
{
    public ConsoleProxyData(
            CurlConsoleFactory curlConsoleFactory)
    {
        super(curlConsoleFactory);
    }

    public void openConsole()
    {
        fMediatorConnection.async.execute(new AsynchronousRemoteOperation(
                MediatorConnection.commandMakeConsoleAgent) {
            @Override
            protected void writeArguments()
            {
                write(CurlPlugin.getDefault().getWorkbenchProxy().getProxyID());
                write(fProxyID);
            }
        });
    }

    public void removeConsole()
    {
        fMediatorConnection.async.execute(new AsynchronousRemoteOperation(
                MediatorConnection.commandRemoveConsoleAgent) {
            @Override
            protected void writeArguments()
            {
                write(CurlPlugin.getDefault().getWorkbenchProxy().getProxyID());
                write(fProxyID);
            }
        });
        destroy();
    }

    /**
     * Respond to mediator command that a string has been inserted into the editor buffer.
     */
    static
    {
        EclipseServer.register(MediatorConnection.commandConsoleOutput, new ConsoleOutputCommandHandler());
    }

    public static class ConsoleOutputProxyCommand
    {
        public String consoleText;
    }

    public static class ConsoleOutputCommandHandler 
        extends ProxyCommandHandler<ConsoleProxyData, ConsoleOutputProxyCommand>
    {        
        @Override
        ConsoleOutputProxyCommand decode(
                DataInputStream sockIn)
        {
            ConsoleOutputProxyCommand command = new ConsoleOutputProxyCommand();
            command.consoleText = DataIO.readString(sockIn);
            return command;
        }
        
        @Override
        void execute(
                final ConsoleOutputProxyCommand command,
                final ConsoleProxyData proxy,
                DataOutputStream sockOut)
        {
            ((CurlConsoleFactory)proxy.getProxyOf()).writeToConsoleResponse(command.consoleText);
        }
    }
}
