/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.properties;

import com.curl.eclipse.remote.DialogViewProxy;
import com.curl.eclipse.remote.StyleSheetProjectPropertiesDialogViewProxy;
import com.curl.eclipse.util.CurlUIIDs;

/**
 * Page for Curl style sheet project property
 */
public class CurlStyleSheetProjectPropertiesPage extends CurlPropertiesPage
{
    public CurlStyleSheetProjectPropertiesPage()
    {
        super(CurlUIIDs.ID_STYLE_SHEET_PROJECT_PROPERTIES_CONTEXT_ID);
    }

    @Override
    protected DialogViewProxy makeProxy(
            String curlProjectURL)
    {
        return new StyleSheetProjectPropertiesDialogViewProxy(this, curlProjectURL);
    }
}
