/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.properties;

import java.net.URL;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;

import com.curl.eclipse.remote.DialogViewProxy;
import com.curl.eclipse.util.CoreUtil;

/**
 * Abstract properties page for any specific Curl property page.
 */
public abstract class CurlPropertiesPage extends PropertyPage implements IWorkbenchPropertyPage
{
    protected Composite fComposite;
    protected DialogViewProxy fViewProxy;
    protected IProject fProject;
    private final String fPageHelpID;

    public CurlPropertiesPage(String helpID)
    {
        super();
        fPageHelpID = helpID;
    }

    @Override
    public void createControl(
            Composite parent)
    {
        noDefaultAndApplyButton();
        super.createControl(parent);
    }

    @Override
    protected Control createContents(
            Composite parent)
    {
        fComposite = new Composite(parent, SWT.NONE);
        // Should I do this so initial Curl view is sized properly ???
        // fPropertiesParent.setSize(parent.getSize());
        establishViewProxy();
        PlatformUI.getWorkbench().getHelpSystem().setHelp(fComposite, fPageHelpID);
        return fComposite;
    }

    @Override
    public void dispose()
    {
        fViewProxy.destroy();
        super.dispose();
    }

    @Override
    public boolean performOk()
    {
        boolean succeeded = false;
        if (fViewProxy.performValidation()) {
            // Dialog is validated. Tell the proxy to commit
            fViewProxy.performCommit();
            succeeded = true;
        }
        return succeeded;
    }

    @Override
    public void setSize(
            Point p)
    {
        super.setSize(p);
        fViewProxy.resizePage(fComposite);
    }

    @Override
    public void setVisible(
            boolean visible)
    {
        super.setVisible(visible);
        if (visible)
            fViewProxy.setFocus();
        else
            fViewProxy.releaseFocus();
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.ui.IWorkbenchPropertyPage#getElement()
     */
    @Override
    public IAdaptable getElement()
    {
        return fProject;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.ui.IWorkbenchPropertyPage#setElement(org.eclipse.core.runtime.IAdaptable)
     */
    @Override
    public void setElement(
            IAdaptable element)
    {
        fProject = (IProject)element.getAdapter(IResource.class);
    }

    protected void establishViewProxy()
    {
        if (fViewProxy == null) {
            URL url = CoreUtil.getCurlProjectURL(fProject, true);
            if (url == null) {
                // TODO: Give an error to the user
                return;
            }
            fViewProxy = makeProxy(url.toString());
            fViewProxy.createViewForDialog(fComposite);
        }
    }

    protected abstract DialogViewProxy makeProxy(
            String curlProjectURL);
}
