/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.properties;

import com.curl.eclipse.remote.DialogViewProxy;
import com.curl.eclipse.remote.GeneralProjectPropertiesDialogViewProxy;
import com.curl.eclipse.util.CurlUIIDs;

/**
 * Proxy for Curl general project preferences
 */
public class CurlGeneralProjectPropertiesPage extends CurlPropertiesPage
{
    public CurlGeneralProjectPropertiesPage()
    {
        super(CurlUIIDs.ID_GENERAL_PROJECT_PROPERTIES_CONTEXT_ID);
    }

    @Override
    protected DialogViewProxy makeProxy(
            String curlProjectURL)
    {
        return new GeneralProjectPropertiesDialogViewProxy(this, curlProjectURL);
    }
}
