/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.preferences;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

import com.curl.eclipse.remote.DialogViewProxy;

/**
 * Abstract preference page for any specific preferences page.
 */
public abstract class CurlPreferencesPage extends PreferencePage implements IWorkbenchPreferencePage
{
    protected Composite fComposite;
    protected DialogViewProxy fViewProxy;
    private final String fPageHelpID;

    public CurlPreferencesPage(String helpID)
    {
        super();
        fPageHelpID = helpID;
    }

    public void init(
            IWorkbench workbench)
    {
    }

    @Override
    protected Control createContents(
            Composite parent)
    {
        fComposite = new Composite(parent, SWT.NULL);
        // Should I do this so initial Curl view is sized properly ???
        // fPreferencesParent.setSize(parent.getSize());
        noDefaultAndApplyButton();
        establishViewProxy();
        PlatformUI.getWorkbench().getHelpSystem().setHelp(fComposite, fPageHelpID);
        return fComposite;
    }

    @Override
    public void dispose()
    {
        fViewProxy.destroy();
        super.dispose();
    }

    @Override
    public boolean performOk()
    {
        boolean succeeded = false;
        if (fViewProxy.performValidation()) {
            // Dialog is validated. Tell the proxy to commit
            fViewProxy.performCommit();
            succeeded = true;
        }
        return succeeded;
    }

    @Override
    public void setSize(
            Point p)
    {
        super.setSize(p);
        fViewProxy.resizePage(fComposite);
    }

    @Override
    public void setVisible(
            boolean visible)
    {
        super.setVisible(visible);
        if (visible)
            fViewProxy.setFocus();
        else
            fViewProxy.releaseFocus();
    }

    protected void establishViewProxy()
    {
        if (fViewProxy == null) {
            DialogViewProxy proxy = makeProxy();
            proxy.createViewForDialog(fComposite);
            fViewProxy = proxy;
        }
    }

    protected abstract DialogViewProxy makeProxy();
}
