/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.perspectives;

import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;
import org.eclipse.ui.console.IConsoleConstants;
import org.eclipse.ui.navigator.resources.ProjectExplorer;
import org.eclipse.ui.progress.IProgressConstants;

import com.curl.eclipse.util.CurlUIIDs;

public class DevelopmentPerspectiveFactory implements IPerspectiveFactory
{
    public DevelopmentPerspectiveFactory() {
        super();
    }

    public void createInitialLayout(
            IPageLayout layout)
    {
        String editorArea = layout.getEditorArea();
        
        IFolderLayout topLeft = layout.createFolder("topLeft", IPageLayout.LEFT, (float)0.25, editorArea); //$NON-NLS-1$
        topLeft.addView(ProjectExplorer.VIEW_ID);
        topLeft.addView(CurlUIIDs.ID_CURL_MANIFEST_EXPLORER);
        topLeft.addView(CurlUIIDs.ID_CURL_DEFINITIONS);
        
        IFolderLayout bottom = layout.createFolder("bottom", IPageLayout.BOTTOM, (float)0.75, editorArea); //$NON-NLS-1$
        bottom.addView(IPageLayout.ID_PROBLEM_VIEW);
        bottom.addPlaceholder(NewSearchUI.SEARCH_VIEW_ID);
        bottom.addView(IConsoleConstants.ID_CONSOLE_VIEW);
        bottom.addPlaceholder(IPageLayout.ID_BOOKMARKS);
        bottom.addPlaceholder(IProgressConstants.PROGRESS_VIEW_ID);
        
        layout.addView(IPageLayout.ID_OUTLINE, IPageLayout.RIGHT, (float)0.75, editorArea);
        
        layout.addActionSet(IDebugUIConstants.LAUNCH_ACTION_SET); 
        layout.addActionSet(CurlUIIDs.ID_ELEMENT_CREATION_ACTION_SET);
        layout.addActionSet(CurlUIIDs.ID_PROJECT_ACTION_SET);
        layout.addActionSet(IPageLayout.ID_NAVIGATE_ACTION_SET);
        layout.addActionSet(CurlUIIDs.ID_CURL_TOOLS_ACTION_SET);
        layout.addActionSet(CurlUIIDs.ID_CURL_DEBUG_ACTION_SET);
        
        // views shortcuts - java
        // layout.addShowViewShortcut(JavaUI.ID_PACKAGES);
        // layout.addShowViewShortcut(JavaUI.ID_TYPE_HIERARCHY);
        // layout.addShowViewShortcut(JavaUI.ID_SOURCE_VIEW);
        // layout.addShowViewShortcut(JavaUI.ID_JAVADOC_VIEW);
        
        // views shortcuts - search
        layout.addShowViewShortcut(NewSearchUI.SEARCH_VIEW_ID);
        
        // views - debugging
        layout.addShowViewShortcut(IConsoleConstants.ID_CONSOLE_VIEW);
        
        // views - standard workbench
        layout.addShowViewShortcut(IPageLayout.ID_OUTLINE);
        layout.addShowViewShortcut(IPageLayout.ID_PROBLEM_VIEW);
        layout.addShowViewShortcut(IPageLayout.ID_RES_NAV);
        layout.addShowViewShortcut(IPageLayout.ID_TASK_LIST);
        layout.addShowViewShortcut(IProgressConstants.PROGRESS_VIEW_ID);

        // new actions - Java project creation wizard
        layout.addNewWizardShortcut("com.curl.eclipse.wizards.NewProjectWizard"); //$NON-NLS-1$
        layout.addNewWizardShortcut("com.curl.eclipse.wizards.NewPackageWizard"); //$NON-NLS-1$
        layout.addNewWizardShortcut("com.curl.eclipse.wizards.NewFileWizard"); //$NON-NLS-1$
        layout.addNewWizardShortcut("org.eclipse.ui.wizards.new.folder");//$NON-NLS-1$
        layout.addNewWizardShortcut("org.eclipse.ui.wizards.new.file");//$NON-NLS-1$
        layout.addNewWizardShortcut("org.eclipse.ui.editors.wizards.UntitledTextFileWizard");//$NON-NLS-1$
    }
}
