/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.files;

import java.io.InputStream;

import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

/**
 * A storage for curl.io.File.
 * 
 * The only use for this class is to implement opening a file that is not in any
 * projects or external to the workspace using the Curl editor.
 * 
 * This file was extracted from JavaFileStorage.java. If someday we find a
 * generic equivalent in some common package (not Java), then we should just use
 * that class and not have our own
 * 
 */
class CurlExternalFileStorage implements IStorage
{
    private IFileStore fFileStore;
    private IPath fFullPath;

    public CurlExternalFileStorage(IFileStore fileStore) {
        fFileStore = fileStore;
    }

    /*
     * @see org.eclipse.core.resources.IStorage#getContents()
     */
    public InputStream getContents() throws CoreException
    {
        return fFileStore.openInputStream(EFS.NONE, null);
    }

    /*
     * @see org.eclipse.core.resources.IStorage#getFullPath()
     */
    public IPath getFullPath()
    {
        if (fFullPath == null)
            fFullPath = new Path(fFileStore.toURI().getPath());
        return fFullPath;
    }

    /*
     * @see org.eclipse.core.resources.IStorage#getName()
     */
    public String getName()
    {
        return fFileStore.getName();
    }

    /*
     * @see org.eclipse.core.resources.IStorage#isReadOnly()
     */
    public boolean isReadOnly()
    {
        return fFileStore.fetchInfo().getAttribute(EFS.ATTRIBUTE_READ_ONLY);
    }

    /*
     * @see org.eclipse.core.runtime.IAdaptable#getAdapter(java.lang.Class)
     */
    @SuppressWarnings("unchecked") 
    public Object getAdapter(
            Class adapter)
    {
        return null;
    }
}
