/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.files;

import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.model.IWorkbenchAdapter;

/**
 * Curl editor input for files not in any open projects or external to
 * workspace.
 * 
 * The only use for this class is to implement opening a file that is not in any
 * projects using the Curl editor
 */
public class CurlExternalFileEditorInput implements IPathEditorInput, IStorageEditorInput, ILocationProvider
{
    /**
     * The workbench adapter which simply provides the label.
     */
    private class WorkbenchAdapter implements IWorkbenchAdapter
    {
        /*
         * @see org.eclipse.ui.model.IWorkbenchAdapter#getChildren(java.lang.Object)
         */
        public Object[] getChildren(
                Object o)
        {
            return null;
        }

        /*
         * @see org.eclipse.ui.model.IWorkbenchAdapter#getImageDescriptor(java.lang.Object)
         */
        public ImageDescriptor getImageDescriptor(
                Object object)
        {
            return null;
        }

        /*
         * @see org.eclipse.ui.model.IWorkbenchAdapter#getLabel(java.lang.Object)
         */
        public String getLabel(
                Object o)
        {
            return ((CurlExternalFileEditorInput)o).getName();
        }

        /*
         * @see org.eclipse.ui.model.IWorkbenchAdapter#getParent(java.lang.Object)
         */
        public Object getParent(
                Object o)
        {
            return null;
        }
    }
    private final IFileStore fFileStore;
    private final WorkbenchAdapter fWorkbenchAdapter;
    private IStorage fStorage;
    private IPath fPath;

    public CurlExternalFileEditorInput(IFileStore fileStore) {
        fFileStore = fileStore;
        fWorkbenchAdapter = new WorkbenchAdapter();
    }

    /*
     * @see org.eclipse.ui.IEditorInput#exists()
     */
    public boolean exists()
    {
        return fFileStore.fetchInfo().exists();
    }

    /*
     * @see org.eclipse.ui.IEditorInput#getImageDescriptor()
     */
    public ImageDescriptor getImageDescriptor()
    {
        return null;
    }

    /*
     * @see org.eclipse.ui.IEditorInput#getName()
     */
    public String getName()
    {
        return fFileStore.getName();
    }

    /*
     * @see org.eclipse.ui.IEditorInput#getPersistable()
     */
    public IPersistableElement getPersistable()
    {
        return null;
    }

    /*
     * @see org.eclipse.ui.IEditorInput#getToolTipText()
     */
    public String getToolTipText()
    {
        return fFileStore.toString();
    }

    /*
     * @see org.eclipse.core.runtime.IAdaptable#getAdapter(java.lang.Class)
     */
    @SuppressWarnings("unchecked") 
    public Object getAdapter(
            Class adapter)
    {
        if (ILocationProvider.class.equals(adapter))
            return this;
        if (IWorkbenchAdapter.class.equals(adapter))
            return fWorkbenchAdapter;
        return Platform.getAdapterManager().getAdapter(this, adapter);
    }

    /*
     * @see org.eclipse.ui.editors.text.ILocationProvider#getPath(java.lang.Object)
     */
    public IPath getPath(
            Object element)
    {
        if (element instanceof CurlExternalFileEditorInput)
            return ((CurlExternalFileEditorInput)element).getPath();
        return null;
    }

    /*
     * @see org.eclipse.ui.IPathEditorInput#getPath()
     * @since 3.1
     */
    public IPath getPath()
    {
        if (fPath == null)
            fPath = new Path(fFileStore.toURI().getPath());
        return fPath;
    }

    /*
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(
            Object o)
    {
        if (o == this)
            return true;
        if (o instanceof CurlExternalFileEditorInput) {
            CurlExternalFileEditorInput input = (CurlExternalFileEditorInput)o;
            return fFileStore.equals(input.fFileStore);
        }
        if (o instanceof IPathEditorInput) {
            IPathEditorInput input = (IPathEditorInput)o;
            return getPath().equals(input.getPath());
        }
        return false;
    }

    /*
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode()
    {
        return fFileStore.hashCode();
    }

    /*
     * @see org.eclipse.ui.IStorageEditorInput#getStorage()
     */
    public IStorage getStorage() throws CoreException
    {
        if (fStorage == null)
            fStorage = new CurlExternalFileStorage(fFileStore);
        return fStorage;
    }
}
