/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.editors;

import java.net.MalformedURLException;

import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.IEditorLauncher;

import com.curl.eclipse.CurlPlugin;
import com.curl.eclipse.util.CoreUtil;
import com.curl.eclipse.util.CurlUIIDs;

public class VLEEditor implements IEditorLauncher
{

    public void open(
            IPath file)
    {
        try {
            CurlPlugin.getDefault().getWorkbenchProxy().getWorkbenchOperations().launchTool(
                    CurlUIIDs.TOOL_ID_VISUAL_LAYOUT_EDITOR,
                    file.toFile().toURI().toURL());
        } catch (MalformedURLException e) {
            CoreUtil.logError("", e); //$NON-NLS-1$
        }
    }
}
