/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.editors;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;

import com.curl.eclipse.remote.SourceViewProxy;

class ToggleBreakpointAdapter implements IToggleBreakpointsTarget
{
    private final SourceViewProxy fSourceViewProxy;

    ToggleBreakpointAdapter(
            SourceViewProxy sourceViewProxy)
    {
        fSourceViewProxy = sourceViewProxy;
    }

    public boolean canToggleLineBreakpoints(
            IWorkbenchPart part,
            ISelection selection)
    {
        return fSourceViewProxy.canDoOperation(SourceViewProxy.TOGGLE_BREAKPOINT_OPERATION);
    }

    public boolean canToggleMethodBreakpoints(
            IWorkbenchPart part,
            ISelection selection)
    {
        // TODO not yet implemented
        return false;
    }

    public boolean canToggleWatchpoints(
            IWorkbenchPart part,
            ISelection selection)
    {
        // TODO not yet implemented
        return false;
    }

    public void toggleLineBreakpoints(
            IWorkbenchPart part,
            ISelection selection) throws CoreException
    {
        fSourceViewProxy.doOperation(SourceViewProxy.TOGGLE_BREAKPOINT_OPERATION);
    }

    public void toggleMethodBreakpoints(
            IWorkbenchPart part,
            ISelection selection) throws CoreException
    {
        // TODO not yet implemented
    }

    public void toggleWatchpoints(
            IWorkbenchPart part,
            ISelection selection) throws CoreException
    {
        // TODO not yet implemented
    }
}
