/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.editors;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.ui.actions.IRunToLineTarget;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;

import com.curl.eclipse.remote.SourceViewProxy;

class RunToLineAdapter implements IRunToLineTarget
{
    private final SourceViewProxy fSourceViewProxy;

    RunToLineAdapter(
            SourceViewProxy sourceViewProxy)
    {
        fSourceViewProxy = sourceViewProxy;
    }

    public boolean canRunToLine(
            IWorkbenchPart part,
            ISelection selection,
            ISuspendResume target)
    {
        return fSourceViewProxy.canDoOperation(SourceViewProxy.CONTINUE_TO_HERE_OPERATION);
    }

    public void runToLine(
            IWorkbenchPart part,
            ISelection selection,
            ISuspendResume target) throws CoreException
    {
        fSourceViewProxy.doOperation(SourceViewProxy.CONTINUE_TO_HERE_OPERATION);
    }
}
