/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.debug;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

class Util
{
    private static final Pattern CURL_BUFFER_URL_PATTERN = Pattern.compile("curl://buffer/\\d+/\\d+/(.*)"); //$NON-NLS-1$
    private static final String CURL_READ_URL_PREFIX = "curl://read/"; //$NON-NLS-1$

    static String normalizeURL(
            String uri)
    {
        Matcher matcher = Util.CURL_BUFFER_URL_PATTERN.matcher(uri);
        String uriToMatch;
        if (matcher.matches()) {
            uriToMatch = matcher.group(1);
        }
        else {

            if (uri.startsWith(CURL_READ_URL_PREFIX)) {
                uri = uri.substring(CURL_READ_URL_PREFIX.length());
            }
            uriToMatch = uri;
        }
        return uriToMatch;
    }
}
