/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.debug;

import java.lang.ref.WeakReference;
import java.net.URI;
import java.util.Hashtable;

import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileSystem;

public class RemoteSourceFileSystem extends FileSystem
{
    /** release file store when no longer referenced */
    private final Hashtable<URI, WeakReference<RemoteSourceFileStore>> fMap = 
        new Hashtable<URI, WeakReference<RemoteSourceFileStore>>();

    public RemoteSourceFileSystem()
    {
    }

    @Override
    public IFileStore getStore(URI uri)
    {
        RemoteSourceFileStore store;
        synchronized(fMap)
        {
            WeakReference<RemoteSourceFileStore> weakReference = fMap.get(uri);
            if (weakReference == null || ((store = weakReference.get()) == null)) {
                store = new RemoteSourceFileStore(uri);
                fMap.put(uri, new WeakReference<RemoteSourceFileStore>(store));
            }
        }
        return store;
    }
}
